"Macro Data Sheet file v. 1"
gamesystem GURPS

title "GURPS Basic Set (v. 3.0.0)"

version 253
level 3

copyright "Copyright  1986-2001 Steve Jackson Games Incorporated. All rights reserved. \
GURPS is a registered trademark of Steve Jackson Games Incorporated."

logo GURPS/BasicSet.lgo
help gurps.hlp

define

var mu3pmu2 0
var mu2pmu1 0
var dpmu1 0
var ms1 "''"
var ms2 "'s'"
var ms3 "'d'"

var getmon "{\r\n\
local str, n;\r\n\
str = DialogFieldValue('Configuration', 'MoneySymbols');\r\n\
if (!str)\r\n\
  str = ConfigParam('MoneySymbols');\r\n\
endif\r\n\
if (!str) return 0; endif\r\n\
n = split(str, '/', 'ms1', 'dpmu1', 'mu2pmu1', 'ms2', 'mu3pmu2', 'ms3');\r\n\
return str;\r\n\
}"

func "mcat(base,val)"
"{\r\n\
if (base)\r\n\
  return concat(concat(base, ' '), val);\r\n\
endif\r\n\
return val;\r\n\
}"

func fbn(d) "{\r\n\
	local ndigits, val, divisor;\r\n\
	if (d < 1 or d != integer(d))\r\n\
		return format('%2n',d);\r\n\
	elseif (d >= 10000000)\r\n\
		ndigits = integer(log10(d));\r\n\
		ndigits = integer(ndigits / 3) * 3 - 3;\r\n\
		divisor = 10^ndigits;\r\n\
		val = format('%n%s',round(d/divisor), \r\n\
			dupstr(substr(format('%n',1000), 2, 4),ndigits/3));\r\n\
	else\r\n\
		val = format('%n', d);\r\n\
	endif\r\n\
	return val;\r\n\
}\r\n\
"

func dm(dollars) "{\r\n\
	local mu1, mu2, mu3, pence, mu3pmu1, val, d, sign;\r\n\
	mu3pmu1 = mu3pmu2 * mu2pmu1;\r\n\
	if (dollars < 0)\r\n\
		sign = '-';\r\n\
		d = -dollars;\r\n\
	else\r\n\
		d = dollars;\r\n\
		sign = '';\r\n\
	endif\r\n\
	if (!dpmu1)\r\n\
		return format('%s$%s', sign, fbn(d));\r\n\
	elseif (mu3pmu1 = 0)\r\n\
		return format('%s%s%s', sign, ms1, fbn(d/dpmu1));\r\n\
	endif\r\n\
	pence=d*(mu3pmu1/dpmu1);\r\n\
	mu1=integer(pence/mu3pmu1);\r\n\
	mu2=integer((pence MOD mu3pmu1)/mu3pmu2);\r\n\
	mu3=round(pence MOD mu3pmu2);\r\n\
	if (mu1 > 1000000)\r\n\
		return format('%s%s%s', sign, ms1, fbn(mu1));\r\n\
	endif\r\n\
	val = '';\r\n\
	if (mu1)\r\n\
		val = mcat(val, format('%s%n', ms1, mu1));\r\n\
	endif\r\n\
	if (mu2)\r\n\
		val = mcat(val, format('%d%s', mu2, ms2));\r\n\
	endif\r\n\
	if (mu3)\r\n\
		val = mcat(val, format('%d%s', mu3, ms3));\r\n\
	endif\r\n\
	if (val = '')\r\n\
		return format('%s%s%d', sign, ms1, fbn(mu1));\r\n\
	endif\r\n\
	return concat(sign, val);\r\n\
}"

func dp(dummy) "{\r\n\
  local price;\r\n\
  price = itemInfo('`Price`');\r\n\
  if (price = 0)\r\n\
    return '--';\r\n\
  endif\r\n\
  return dm(price);\r\n\
}"

func dew(lbs) "{\r\n\
local kg;\r\n\
if (ConfigParam('useMetric'))\r\n\
	kg = lbs / 2.2;\r\n\
	if (kg < 1)\r\n\
		return format('%2d', kg);\r\n\
	elseif (kg < 10)\r\n\
		return format('%1d', kg);\r\n\
	endif\r\n\
	return round(kg);\r\n\
endif\r\n\
return lbs;\r\n\
}"

end


# Define PLUGIN as empty since these are the basic rules.

$$define PLUGIN

$$include gurps.inc

cat "Additional Attributes"
	$$note(Note)
		textline rand -1
	$$custAttr(Attribute)
	$$custAttr(Enhanced ST Cost, "enhStCost(x)")
	$$deriv(Derived Attribute)
	sublist Will memlist
		$$deriv(Will, iq*will*0, "(optValue('Based on IQ')?iq:10)+will", wp)
			opt	begin text "Based on IQ" "?+1;" dispexp 'l' noprint end
				end
		$$deriv(Mental Will, iq*will*0, "iq+will", mentalWill)
		$$deriv(Physical Will, ht*will*0, "ht+will", physicalWill)
		$$deriv(Emotional Will, will*0, "10+will", emotionalWill)
		end
	$$deriv(Fright Check, willpower*fright*0, willpower+fright, frightCheck)
	$$deriv(Jump ST, jumpST*0, jumpST, jumpingST)
	$$deriv(Spell-Casting Fatigue, ExtraSpellFatigue*x_st*FatigueBonus*SpellFatigueBonus*0, 
		"x_st-FatigueBonus+SpellFatigueBonus+ExtraSpellFatigue", spellCastingFatigue)
	$$infostat(Broad Jump, 0*jumping*jumpST*superjump, 
		"format('%d ft',max(0,max(jumping,jumpST)-3)*2.0^superjump)")
	$$infostat(High Jump, 0*jumping*jumpST*superjump, 
		"format('%d in',max(max(jumping,jumpST)*3-10,0)*2.0^superjump)")
	$$infostat(Swim, swimmingSpeed*0, swimmingSpeed, swimmingstat)

	sublist "Senses" memlist
		$$sense(Hearing, hearing)
		$$sense(Taste or Smell, tasteorsmell)
		$$sense(Vision, vision)
		end
	end

cat Advantages
	$$note(--)
		textline rand -1 dupexpected
	$$note(Note)
		textline rand -1
	$$sublist(Sublist)
		textline rand -1
	sublist "Mundane Advantages" memlist
		$$cadv	Absolute Direction	5				bodysense+3;navigation+3
		$$cadv	Absolute Timing	5
		$$ladv("Acute Hearing", 2/level, hearing+x, "x*(2-blindness)", , !Disadv:Deafness, *Acute Sense, acutehearing, , , +^v)
			opt	exp Hearing "hearingSense?hearingSense:iq+hearing"
				end
		$$ladv("Acute Taste and Smell", 2/level, tasteorsmell+x, "x*(2-blindness)", , , *Acute Sense, acutetasteandsmell, , , +^v)
			opt	exp "Taste and Smell" "tasteorsmellSense?tasteorsmellSense:iq+tasteorsmell"
				end
		$$ladv("Acute Vision", 2, vision+x;lipreading+x, , , , *Acute Sense, , , , +^v)
			opt	exp Vision "visionSense?visionSense:iq+vision"
				end
		$$ladv(Alertness, 5, hearing+x;vision+x;tasteorsmell+x;faz+x;lipreading+x, , , , *Acute Sense, , , , +^v)

		$$ladv(Ally, 5, , , , , , , "%0ln (^o'Points', ^o'Frequency')%-14rc%-7r! ")
			textline dupexpected
			opt
				begin exp "Points" "format('%d to %d', x=1?76:(x-2)*50+101, (x-1)*50+100)" noprint end
				begin mult "Frequency" "?:2;6 or less,׽;9 or less,1;12 or less,2;15 or less,3" noprint end
				end
		$$nadv(Ally Group, , "$Small;1;Medium;2;Large;3", x*10, x>0 and x<=3, , , , "%0ln (^v, ^o'Frequency')%-14rc%-7r!")
			textline dupexpected
			opt
				add "Point Level" "?:1;75,+0;100,+10"
				begin mult "Frequency" "?:2;6 or less,׽;9 or less,1;12 or less,2;15 or less,3" noprint end
				end
		$$nadv("Ally Group (Unwilling)", , "$Small;1;Medium;2;Large;3", x*10, x>0 and x<=3, , , , "%0ln (^v, ^o'Frequency')%-14rc%-7r!")
			textline dupexpected
			opt
				add "Point Level" "?:1;100,+0;125,+10"
				begin mult "Frequency" "?:2;6 or less,׽;9 or less,1;12 or less,2;15 or less,3" noprint end
				end
		$$cadv(Alternate Identity, 15)
		$$cadv("Alternate Identity (Legal)", 5, "Adv:Legal Enforcement Powers>=2::Must have legal enforcement Advantage at 10+")
		$$cadv(Ambidexterity, 10)
		$$cadv("Animal Empathy", 5, , , , Skills:Animal+4)
			opt text Reaction "+2/+4"
				end
		sublist Appearance sort 1 memlist
			$$nadv(Appearance, appearance+x, "$Attractive;1;$sex=2?'Beautiful':'Handsome';2;$sex=2?'Very Beautiful':'Very Handsome';3",
				"(qindex(x,5,15,25)-qindex(&x+1,0,5,15,25))*(hunchback?2:1)+0*sex", x>0 and x<=3 and c>=0,
				"!#1,Adv:Appearance::Only one Appearance allowed;!#1,Disadv:Appearance::Appearance Disadvantage not allowed",
				Appearance, appadv, "%0ln (^v)%-14rx'displev(@c@)'%-7r!")
				textline cost 5
				opt
					exp Reaction "qindex(x, '+1', '+2/+4', '+2/+6')"
					end
			$$appadv(Attractive, 1, 5, +1)
			$$appadv(Beautiful, 2, 15, +2/+4)
			$$appadv(Handsome, 2, 15, +2/+4)
			$$appadv(Very Handsome, 3, 25, +2/+6)
			$$appadv(Very Beautiful, 3, 25, +2/+6)
			end

		$$ladv(Charisma, 5/level, "Sk:leadership+x;Sk:fortunetelling+x;Sk:panhandling+x;Sk:Bard+x",
			~x*5, x>0 and x>=&x, , , charisma, , , +^v)
			opt
				exp Reaction "format('%+d',x)"
				end
		$$ladv("Clerical Investment", 5, , , , , , ClericalInvestment)
			opt exp Reaction format('%+d',x) end
		$$cadv(Collected, 5, , , , fright+3)
			opt exp "Fright Check" willpower+fright end
		$$zcadv("Combat Reflexes", 15, , Aggressive, , combatreflexes=1;Sk:fastdraw+1;fright+2, , , , vCombatReflexes)
			opt exp "Fright Check" willpower+fright end
		$$cadv("Common Sense", 10)
		$$cadv(Composed, 5, , , , fright+2)
			opt exp "Fright Check" willpower+fright end

		$$nadv(Contacts, , "$12;1;15;2;18;3;21;4", x, x>0 and x<=4, , , , "%0ln (Skill ^v, ^o'Frequency', ^o'Reliability' Reliable)%-14rc%-7r!")
			textline dupexpected
			opt
				begin mult "Frequency" "?:2;6 or less,׽;9 or less,1;12 or less,2;15 or less,3" noprint end
				begin mult Reliability "?:2;Not,׽;Somewhat,1;Usually,2;Completely,3" noprint end
				end

		sublist Favors memlist
			$$ladv("Favor: Ally", 5, , , , , , , "%0ln (^o'Points', ^o'Frequency')%-14rc%-7r! ")
				textline dupexpected
				opt
					begin exp "Points" "format('%d to %d', x=1?76:(x-2)*50+101, (x-1)*50+100)" noprint end
					begin mult "Frequency" "?:2;6 or less,׽;9 or less,1;12 or less,2;15 or less,3" noprint end
					begin mult "Favor" 1/5 noprint end
					end
			$$nadv("Favor: Contact", , "$12;1;15;2;18;3;21;4", x, x>0 and x<=4, , , , "%0ln (Skill ^v, ^o'Frequency', ^o'Reliability' Reliable)%-14rc%-7r!")
				textline dupexpected
				opt
					begin mult "Frequency" "?:2;6 or less,׽;9 or less,1;12 or less,2;15 or less,3" noprint end
					begin mult Reliability "?:2;Not,׽;Somewhat,1;Usually,2;Completely,3" noprint end
					begin mult "Favor" 1/5 noprint end
					end
			$$nadv("Favor: Patron", , 
				"$Powerful Character;1;1000 Wealth Group;2;Very Powerful Character;3;Powerful Group;4;Very Powerful Group;5;Government;6",
					"qindex(x,10,10,15,15,25,30)", x>0 and x<=6, , , , "%0ln (^o'Appears')%-14rc%-7r!")
					textline dupexpected
					opt 
						begin mult "Appears" "?:2;6 or less,1/2;9 or less,1;12 or less,2;15 or less,3" noprint end
						add "Equipment" "?:1;None,0;Standard,+5;Expensive,+10"
						add "Special Qualities" "?:1;None,0;Significant,+5;Very Unusual,+10"
						add Unwilling "?+0;-5"
						begin mult "Favor" 1/5 noprint end
						end
			end

		$$cadv("Danger Sense", 15, , , , "Powers:ESP+5")
		$$cadv(Double-Jointed, 5, , , , "Sk:climbing+3;Sk:escape+3;\"Sk:mechanic\"+3")
		$$ladv("Eidetic Memory", 30, IQm/2^x, , "x>=1 and x<=2", , , eideticbonus)
		$$cadv(Empathy, 15, "!Disadvantages:Low Empathy", , ,
			"Sk:sensitivity+1;Sk:fortunetelling+3;EmpathyBonus+1;Powers:Telepathy+3;Skills:DetectLies+0;Skills:Psychology+0")
		$$ladv(Extra Fatigue, 3/level, x_st+x, ~x*c_xst, , !Disadv:Reduced Fatigue, , , , , +^v)
		$$ladv(Extra Hit Points, 5/level, x_ht+x, ~x*c_xht, , !Disadv:Reduced Hit Points, , , , , +^v)
		$$extramoney(Extra Money)
		$$ladv(Fearlessness, 2, fright+x, , , , , , , , +^v)
			opt exp "Fright Check" willpower+fright end
		$$zcadv("High Pain Threshold", 10, !Disadv:Low Pain Threshold)
		$$zcadv("Immunity to Disease", 10)
		$$zcadv("Intuition", 15)
		$$ladv("Language Talent", 2/level, Sk:Language+x;Sk:Linguistics+x, ~x*2, x>0 and x>=&x, , , languageTalent, , , +^v)
		$$nadv(Legal Enforcement Powers, legalenforcement+c, "$Local;1;National;2;Global;3", x*5, x>0 and x<=3)
		$$nadv(Legal Immunity, , "$Strict Rules;1;Laxer Rules;2;Complete Freedom;3", x*5, x>0 and x<=3)
			opt	add "Diplomatic Pouch" "?:1;No,+0;Yes,+5"
				end
		$$zcadv("Lightning Calculator", 5)
		$$ladv(Literacy, 10, , 10-LiteracyDefault, , !Disadv:Illiteracy;!Adv:Semi-Literacy, , literacy, "%0ln%-14rc%-7r!")
			textline editdlg 4
			opt	begin exp "Norm" "qindex(LiteracyDefault/5+1,'Illiterate','Semi-Literate','Literate')" noprint end
				end
		$$zcadv("Longevity", 5, , , , longevity+1, , , , vLongevity)
		$$nadv(Luck, , "$Born Lucky;1;Extraordinary Luck;2;Ridiculous Luck;3", 
			"qindex(x,15,30,60)-(x>~x?qindex(x-~x,15,30,60):0)", x>0 and x>=&x and x<=3, , , Luck)
		$$zcadv("Mathematical Ability", 10, , , , "Sk:Mathematical+3;Sk:Engineering+0;Sk:Electronics+2;Sk:Photonics+2;Sk:Accounting+5")
		$$ladv("Military Rank", 5, , , "x>=0 and x<=8", , , , , 0)
			textline adj "Adv:Status+`Adds to Status`?round(x/3):0"
			textline script "if (!$+inList(Advantages, Status) and x>1 and optValue('Adds to Status')) addAutoItems \"Status\", rv, deleteauto, noautodup, dontmarkauto, autochargecost; endif"
			opt	begin text "Adds to Status" "?+1;" dispexp 'l' noprint end
				end
		$$ladv("Musical Ability", 1, "\"Sk:Musical Instrument\"+x;Sk:singing+x;Sk:conducting+x;Sk:cyberaxe+x;Sk:musicalcomposition+x", , , , , , , , +^v)
		$$zcadv("Night Vision", 10)
		$$nadv(Patron, , 
			"$Powerful Character;1;1000 Wealth Group;2;Very Powerful Character;3;Powerful Group;4;Very Powerful Group;5;Government;6",
				"qindex(x,10,10,15,15,25,30)", x>0 and x<=6, , , , "%0ln (^o'Appears')%-14rc%-7r!")
				textline dupexpected
				opt 
					begin mult "Appears" "?:2;6 or less,1/2;9 or less,1;12 or less,2;15 or less,3" noprint end
					add "Equipment" "?:1;None,0;Standard,+5;Expensive,+10"
					add "Special Qualities" "?:1;None,0;Significant,+5;Very Unusual,+10"
					add Unwilling "?+0;-5"
					end
		$$nadv("Patron (Church)", , "$Small Church;1;Powerful Church;2;Very Powerful Church;3;Theocracy;4",
			"qindex(x,10,15,25,30)", x>0 and x<=4)
			opt
				begin add "Clerical Investment" "?!@v@>0?(@v@-1)*5:0" itemref ClericalInvestment end 
				end
		$$cadv("Peripheral Vision", 15)
		$$cadv("Rapid Healing", 5, "Main:ht>=10")
		$$ladv(Reputation, 5, , , "abs(x)<=4", , , , , , "^x|format('%+d',@v@)|", "integer((c+a)*@mo@*(max(100+@p@,25)/100)+(@v@<0?-.0001:.0001))")
			textline dupexpected
			opt exp Reaction format('%+d',x)
				mult "Recognized by" "?:1;Everyone,1;Large class,׽;Small class,1/3"
				mult "Frequency of Recognition" "?:1;All the time,1;Sometimes (10-),׽;Occasionally (7-),1/3"
				end
		$$ladv(Semi-Literacy, 5, , 5-LiteracyDefault, , !Disadv:Illiteracy;!Adv:Literacy, , semiliteracy, "%0ln%-14rc%-7r! ")
			textline editdlg 4
			opt	begin exp "Norm" "qindex(LiteracyDefault/5+1,'Illiterate','Semi-Literate','Literate')" noprint end
				end
		$$ladv(Status, 5/level, status+x, "~x*5", c>=0, , , statusAdv)
		$$ladv("Strong Will", 4, will+x, , , "!Disadv:Weak Will", , , , , +^v)
			opt exp "Will" willpower end
		$$ladv(Toughness, 10/25, idr+x, "x=1?10:25", "x>=1 and x<=2")
		$$cadv(Unfazeable, 15)
			textline keepcost
		$$cadv("Unusual Background", 5)
			textline keepcost
		$$zcadv(Voice, 10, , , ,
			"Sk:bard+2;Sk:diplomacy+2;Sk:PerformanceSkill+2;Sk:politics+2;\"Sk:Savoir-Faire\"+2;Sk:sexappeal+2;Sk:singing+2;Sk:Mimicry+1")
			opt
				text Reaction +2
				end
		sublist Wealth sort 4 memlist
			$$cadv(Comfortable Wealth, 10, "!#1,Adv:Wealth;!Disadv:Poverty", Wealth, , wealthAdd+1)
				opt
					exp "Starting Wealth" "dm(wealthFunc(0))"
					end	
			$$cadv(Wealthy, 20, "!#1,Adv:Wealth;!Disadv:Poverty", Wealth, , wealthAdd+2;Adv:Status+1)
				textline script "if (!$+inList(Advantages, Status)) addAutoItems \"Status\", rv, deleteauto, noautodup, dontmarkauto, autochargecost; endif"
				opt
					exp "Starting Wealth" "dm(wealthFunc(0))"
					begin exp Status status noprint end
					end	
			$$cadv(Very Wealthy, 30, "!#1,Adv:Wealth;!Disadv:Poverty", Wealth, , wealthAdd+3;Adv:Status+1)
				textline script "if (!$+inList(Advantages, Status)) addAutoItems \"Status\", rv, deleteauto, noautodup, dontmarkauto, autochargecost; endif"
				opt
					exp "Starting Wealth" "dm(wealthFunc(0))"
					begin exp Status status noprint end
					end	
			$$cadv(Filthy Rich, 50, "!#1,Adv:Wealth;!Disadv:Poverty", Wealth, , wealthAdd+4;Adv:Status+1)
				textline script "if (!$+inList(Advantages, Status)) addAutoItems \"Status\", rv, deleteauto, noautodup, dontmarkauto, autochargecost; endif"
				opt
					exp "Starting Wealth" "dm(wealthFunc(0))"
					begin exp Status status noprint end
					end	
			$$nadv(Wealth, "wealthAdd+x;Adv:Status+(x>1)", "$Comfortable;1;Wealthy;2;Very Wealthy;3;Filthy Rich;4",
				"qindex(x,10,20,30,50)", x>0 and x<=4,
				"!#1,Adv:Wealth;!Disadv:Poverty", Wealth, , "%0ln (^v)%-12rc%-7r!")
				textline script "if (!$+inList(Advantages, Status) and $*wealth>1) addAutoItems \"Status\", rv, deleteauto, noautodup, dontmarkauto, autochargecost; endif"
				opt
					exp "Starting Wealth" "dm(wealthFunc(0))"
					begin exp Status status noprint end
					end	
			$$ladv(Multimillionaire, 25/level, "wealthAdd+x;Adv:Status+min(x,2)", "x*25", ,
				"!#1,Adv:Multimillionaire~Adv:Filthy Rich|Adv:Wealth=4", , , "%0ln%-12rc%-7rv")
			end
		$$cadv(Zeroed, 10)
		end
	sublist "Cinematic" memlist
		$$ladv(Hard to Kill, 5, , , , , Cinematic)
			opt exp Note "format('+%d to HT for Survival Rolls',x)" end
		end

	sublist "Generic Advantages" 
			textline rand -1
		memlist
		$$costOfLiving	Cost of Living
			textline rand -1
		$$cadv("Generic Advantage", 10)
			textline rand -1
			keepcost
		$$ladv("Generic Level Advantage", Variable, , "x*itemInfo('`Level Cost`')")
			textline rand -1
			opt
				text "Level Cost" "??1;1;x;x>0"
				end
		$$csupadv("Generic Super Advantage (Fixed)", 10)
			textline rand -1 keepcost
		$$lsupadv("Generic Super Advantage (Variable)", 5, , , , , "x*itemInfo('`Level Cost`')")
			textline rand -1
			opt
				begin text "Level Cost" "??1;1;x;x>0" noprint end
				end
		end
	sublist "Occult and Paranormal Advantages" memlist
		$$ladv("Blessed", 10, "Spells:Divination+x>1?5:0", , x>0 and x<3, , Occult/Paranormal)
			opt
				text "Reaction" "+1 Deity's Followers"
				end
		$$ladv(Destiny, 5, , , x>0 and x<4, !Disadv:Destiny, Occult/Paranormal)
		$$ladv(Extra Spell-Casting Fatigue, 2, extraSpellFatigue+x, , , , , , "%0ln%-14rc%-7r!+^v")
			opt exp "Spell-Casting Fatigue" "x_st-FatigueBonus+SpellFatigueBonus+ExtraSpellFatigue" end
		$$ladv(Magery, Variable, thaumatology+x, "mc(x,&magery)", c>=0 and x>0, "!#1,Adv:Magical Aptitude", Magery;Magical Aptitude, magery)
		$$ladv("Magery: One College", Variable, "thaumatology+x;\"Spells:`~College`\"+x",
			"magery>0?x*6:(x<=0?0:10+(x-1)*6)", x>=0, , Magery, mageryonecollege,
			"%0ln (^o'College')%-14rc%-7ro'Effective Level'")
			textline dupexpected
			opt
				begin exp "Effective Level" "magery+x" noprint end
				begin text College "?:1;Choose;Animal;Body Control;Communication and Empathy;Earth;Air;Fire;Water;Enchantment;Food;Gate;Healing;Illusion and Creation;Knowledge;Light and Darkness;Making and Breaking;Meta-Spell;Mind Control;Movement;Necromantic;Plant;Protection and Warning;Sound;Technological" 
					noprint end
				end
		$$ladv("Magic Resistance", 2, , , , , Occult/Paranormal)
		end
	
	end

cat Disadvantages
	$$note(--)
		textline rand -1 dupexpected
	$$note(Note)
		textline rand -1
	$$q	Quirk
		textline rand -1 dupexpected
	$$sublist(Sublist)
		textline rand -1
	sublist "Generic Disadvantages" 
			textline rand -1
		memlist
		$$cadv("Generic Disadvantage", -10)
			textline rand -1 keepcost
		$$ladv("Generic Level Disadvantage", Variable, , "x*itemInfo('`Level Cost`')")
			textline rand -1
			opt
				text "Level Cost" "??-5;-5;x;x<0"
				end
		$$csupadv("Generic Super Disadvantage (Fixed)", -10, , , , , Super Disadvantage)
			textline rand -1 keepcost
		$$lsupadv("Generic Super Disadvantage (Variable)", -5, , , , , "x*itemInfo('`Level Cost`')", , , , Super Disadvantage)
			textline rand -1
			opt
				begin text "Level Cost" "??-5;-5;x;x>0" noprint end
				end
		end

	sublist "Mental Disadvantages" memlist
		$$cadv("Absent-Mindedness", -15, , Mental)
		$$nadv(Addiction, , "$Cheap;1;Expensive;2;Very Expensive;3", "qindex(x,-5,-10,-20)", x>0 and x<=3, , Mental)
			textline dupexpected
		$$cadv("Alcoholism", -15, , Mental)
			opt add "Legality" "?:1;Legal,0;Illegal,-5" end
		$$nadv(Amnesia, , "$Partial;1;Total;2", x=1?-10:-25, x>0 and x<=2, , Mental)
		$$cadv("Bad Temper", -10, "!Berserk", Mental;Aggressive)
		$$zcadv(Berserk, -15, "!Bad Temper;!#1,Disadv:Pacifism", Mental;Aggressive)
		$$rcadv(Bloodlust, -10, , Mental;Aggressive)
		$$cadv(Bully, -10, , Mental;Aggressive)
		$$nadv(Code of Honor, , "$Minor;1;Major;2;Restrictive;3", "x*-5", x>0 and x<=3)
			textline dupexpected
		$$cadv("Combat Paralysis", -15, , Mental)
		sublist "Compulsive Behaviors" memlist
			$$nadv("Compulsive Behavior", , "$Minor;1;Major;2;Severe;3", x*-5, x>0 and x<=3, , Mental)
				textline dupexpected
			$$cadv(Compulsive Carousing, -5, , Mental)
				opt	add "Puritanical Society" ?+0;-5
					end
			$$cadv("Compulsive Generosity", -5, , Mental)
			$$cadv("Compulsive Lying", -15, , Mental)
				$$reqroll	Will-4
			$$nadv("Compulsive Spending", , "$Mild;1;Serious;2;Wastrel;3", x*-5, x>0 and x<=3, , Mental)
			end
		$$cadv(Cowardice, -10, , Mental)
			$$reqroll	Will, Death: Will-5
		$$nadv(Curious, , "$Mildly;1;Extremely;2;Insatiably;3", x*-5, x>0 and x<=3, , Mental)
			opt exp "Roll" "qindex(x, 'IQ', 'IQ-2', 'IQ-5')"
				end
		
		$$nadv(Delusion, , "$Quirk;1;Minor;2;Major;3;Severe;4", "qindex(x,-1,-5,-10,-15)", x>0 and x<=4, , Mental)
			textline dupexpected
		$$ladv(Dyslexia, Variable, , "x-10*(tl>4)", x<=0, , Mental, dyslexia, "%0ln (TL ^x'tl')%-14rc%-7r!", -5)
			textline editdlg 4
		$$cadv(Fanaticism, -15, , Mental)
		$$cadv("Fanaticism (Self)", -15, , Mental)
		$$nadv(Flashbacks, , "$Minor;1;Serious;2;Severe;3", x*-5, x>0 and x<=3, , Mental)
		$$cadv(Gluttony, -5, , Mental)
		$$cadv("Glory Hound", -15, "!Overconfidence", Mental)
		$$cadv(Greed, -15, , Mental)
		$$cadv(Gullibility, -10, , Mental, , "Sk:merchant-3")
		$$cadv(Honesty, -10, , Mental)
		$$ladv(Illiteracy, -10, , 0-LiteracyDefault, , !Disadv:Literacy;!Adv:Semi-Literacy, Mental, illiteracy, "%0ln%-14rc%-7r!")
			textline editdlg 4
			opt	begin exp "Norm" "qindex(LiteracyDefault/5+1,'Illiterate','Semi-Literate','Literate')" noprint end
				end
		$$cadv(Impulsiveness, -10, , Mental)
		$$cadv(Incompetence, -1, "!#6,Disadv:Incompetence", Mental;Incompetence)
		$$nadv(Intolerance, , "$Specific;1;Thorough;2", "x=1?-5:-10", x>0 and x<=2, , Mental)
			textline dupexpected
		$$cadv(Jealousy, -10, , Mental)
		
		$$cadv(Kleptomania, -15, , Mental)
		$$cadv(Laziness, -10, , Mental)
		$$cadv(Lecherousness, -15, , Mental)
			$$reqroll	Will: -5/Beautiful, -10/Very Beautiful
		$$cadv	Manic-Depressive	-20		Mental
		$$cadv(Megalomania, -10, "Fanaticism (Self)", Mental)
		$$cadv(Miserliness, -10, , Mental)
		$$cadv	No Sense of Humor	-10		Mental
		$$ladv(Obsession, -5, , , x>0 and x<4, , Mental)
		$$cadv	On the Edge	-15		Mental
		$$cadv(Overconfidence, -10, , Mental)
		sublist Pacifism memlist
			$$cadv("Pacifism (Cannot Kill)", -15, "!#1,Disadv:Pacifism", Mental;*Pacifism)
			$$cadv("Pacifism (Self-Defense Only)", -15, "!#1,Disadv:Pacifism", Mental;*Pacifism)
			$$cadv("Pacifism (Total)", -30, "!#1,Disadv:Pacifism", Mental;*Pacifism)
			end
		$$cadv(Paranoia, -10, , Mental)
		sublist Phobias memlist
			$$phobia(Claustrophobia, -15)
			$$phobia("Fear of Crowds", -15)
			$$phobia("Fear of Darkness", -15)
			$$phobia("Fear of Death/Dead", -10)
			$$phobia("Fear of Dirt", -10)
			$$phobia("Fear of Heights", -10)
			$$phobia("Fear of Insects", -10)
			$$phobia("Fear of Loud Noises", -10)
			$$phobia("Fear of Machinery", -5/-15, fearofmachinery, "tl>=5?-15:-5")
			$$phobia("Fear of Technology", -5/-15, fearoftechnology, "tl>=5?-15:-5")
			$$see(Technophobia, , , Fear of Technology)
			$$phobia("Fear of Magic", -10)
			$$phobia("Fear of Magic/no magic", -5)
			$$phobia("Fear of Monsters", -15)
			$$phobia("Fear of Oceans", -10)
			$$phobia("Fear of Open Spaces", -10)
			$$phobia("Fear of Reptiles", -10)
			$$phobia("Fear of Sharp Things/TL5-", -15)
			$$phobia("Fear of Sharp Things/TL6+", -10)
			$$phobia("Fear of the Number 13", -5)
			$$phobia("Fear of the Unknown", -15)
			$$phobia("Fear of Weapons", -20)
			$$phobia(Phobia, -10) 
				textline generic rand -1
			$$phobia(Squeamishness, -10)
			end
		$$cadv(Pyromania, -5, , Mental)
		$$rcadv(Sadism, -15, , Mental)
		$$ladv(Semi-Literacy, 5, , 5-LiteracyDefault, , !Disadv:Illiteracy;!Adv:Literacy, Mental, semiliteracy, "%0ln (Norm: ^o'Norm')%-14rc%-7r!")
			textline editdlg 4
			opt	begin exp "Norm" "qindex(LiteracyDefault/5+1,'Illiterate','Semi-Literate','Literate')" noprint end
				end
		$$ladv(Sense of Duty, -5, , , x>0 and x<=4, , Mental, , "%0ln%-14rc%-7r!")
			dupexpected
		$$nadv("Shyness", , "$Mild;1;Severe;2;Crippling;3", x*-5, x>0 and x<=3, , Mental)
		$$nadv("Split Personality", , "$Aware;1;Unaware;2", x=1?-10:-15, x>0 and x<=2, , Mental)
		$$cadv(Stubbornness, -5, , Mental)
		$$nadv(Trademark, , "$Quirk;1;Simple;2;Distinctive;3;Elaborate;4", "qindex(x,-1,-5,-10,-15)", x>0 and x<=4, , Mental)
		$$cadv(Truthfulness, -5, , Mental)
		$$cadv(Unluckiness, -10, , Mental)
		$$nadv(Vow, , "$Trivial;1;Minor;2;Major;3;Great;4", "x=1?-1:(x-1)*-5", x>0 and x<=4, , Mental)
			textline dupexpected
		$$ladv("Weak Will", -8, will-x, , "x>0 and (wp?x<10:iq-x>0)", , , , , , -^v)
			opt exp "Will" willpower end
		end

	sublist "Physical Disadvantages" memlist
		$$ladv(Age, -3/year, , "(age>aging_age and !longevity)*ceil((age-aging_age)/(1+extLifespan))*-3", ,
			"!Disadvantages:Youth;!#1,Advantages:Unaging;Info:Age>aging_age", Physical, d_age, "%0ln (^x'age')%-14rc%-7r!")
			textline editdlg 2
			opt
				begin adj "ST Decrease" ST+x ??0;0;x;x<=0 noprint end
				begin adj "DX Decrease" DX+x ??0;0;x;x<=0 noprint end
				begin adj "IQ Decrease" IQ+x ??0;0;x;x<=0 noprint end
				begin adj "HT Decrease" HT+x ??0;0;x;x<=0 noprint end
				begin adj "Fatigue Decrease" x_st+x ??0;0;x;x<=0 noprint end
				begin adj "Hit Point Decrease" x_ht+x ??0;0;x;x<=0 noprint end
				begin text "Last Age" ??0 noprint end
				end
		$$cadv(Albinism, -10, , Physical)
		sublist "Bad Sight" memlist
			$$cadv("Bad Sight (Correctable)", -10, "!Blindness;!Adv:Acute Vision;!#1,Disadv:Bad Sight", Physical;*Bad Sight)
			$$cadv("Bad Sight (Farsightedness)", -25, "!Blindness;!Adv:Acute Vision;!#1,Disadv:Bad Sight", Physical;*Bad Sight)
			$$cadv("Bad Sight (Nearsightedness)", -25, "!Blindness;!Adv:Acute Vision;!#1,Disadv:Bad Sight", Physical;*Bad Sight, , "Sk:Melee-2")
			end
		$$cadv(Blindness, -50, !Color Blindness, Physical, ,
			"vision-20;\"Skills:Combat/Weapon\"-6;blindness=1")
		$$cadv("Color Blindness", -10, !Blindness, Physical, , "Sk:Driving-1;Sk:Piloting-1;Sk:chemistry-1;Sk:merchant-1;Sk:tracking-1")
		$$cadv(Deafness, -20, !Adv:Acute Hearing;!Hard of Hearing, Physical, ,
			 "DeafnessLP-3;hearing-20;lipreading+3;\"Sk:Sign Language\"+6;Sk:language-3;Sk:Gesture+6")
		$$cadv(Dwarfism, -15, !Gigantism, Physical, , b_speed-1;m_height-.4;alcoholTolerance-5)
		$$cadv(Epilepsy, -30, , Physical)
		$$cadv(Eunuch, -5, , Physical)
		$$nadv(Fat, "exbodyweight=round(bodyweightfunc(st)*(x=1?.5:1));swimming+5;alcoholTolerance+(x=1?5:10)",
			"$Obese;1;Extremely Obese;2", "x=1?-10:-20", x=1 or x=2, !Overweight;!Skinny, Physical)
				opt exp "Extra Body Weight" exbodyweight 
					exp Reaction -x
					end
		$$cadv(Gigantism, -10, !Dwarfism, Physical, , min_height=84;m_height+.2;alcoholTolerance+8)
		$$cadv("Hard of Hearing", -10, !Adv:Acute Hearing;!Deafness, Physical, , hearing-4)
		$$cadv(Hemophilia, -30, , Physical)

		sublist Lame memlist
			$$cadv("Lame (Crippled Leg)", -15, "!#1,Disad:Lame", Physical;*Lame, , "b_speed+-3;Skills:Melee-3")
			$$cadv("Lame (Legless)", -35, "!#1,Disad:Lame", Physical;*Lame, , "lame=1;maxmove=0;Skills:Melee-6")
			$$cadv("Lame (Paraplegic)", -35, "!#1,Disad:Lame", Physical;*Lame, , "lame=1;maxmove=0;Skills:Melee-6")
			$$cadv("Lame (One Leg)", -25, "!#1,Disad:Lame", Physical;*Lame, , "lame=1;maxmove=2;Skills:Melee-6")
			end
		$$cadv("Low Pain Threshold", -10, !Adv:High Pain Threshold, Physical)
		$$zcadv(Mute, -25, , Physical, , Gesture+3;SignLanguage+3)
		$$cadv(No Sense of Smell/Taste, -5, !Adv:Acute Taste and Smell, Physical, , tasteorsmell-20)
		$$cadv("One Arm", -20, , Physical)
		$$cadv("One Eye", -15, !No Depth Perception, Physical, , "Sk:Melee-1;Sk:Ranged-3;Sk:Driving-3;Sk:Piloting-3;Sk:Powerboat-3;Sk:Motorcycle-3;Sk:ForwardObserver-1")
			opt
				text Reaction -1
				end
		$$cadv("One Hand", -15, , Physical)
		$$cadv(Overweight, -5, !Fat;!Skinny, Physical, , "exbodyweight=round(bodyweightfunc(st)*0.3);swimming+2;alcoholTolerance+3")
			opt exp "Extra body weight" exbodyweight end
		$$ladv(Reduced Fatigue, -3/level, x_st-x, -~x*c_xst, , !Adv:Extra Fatigue, , , , , -^v)
		$$ladv(Reduced Hit Points, -5/level, x_ht-x, -~x*c_xht, , !Adv:Extra Hit Points, , , , , -^v)
		$$cadv(Skinny, -5, 
			"Main:HT<=14;!#1,Advantages:Appearance>1::May not have high Appearance;!Overweight;!Fat", Physical, ,
			"disguise-2;exbodyweight=-round(heightweight(height)/3);alcoholTolerance-3")
			opt exp "Weight" bodyweight end
		$$cadv(Stuttering, -10, , Physical)
			opt exp "Reaction" -2 end
		$$nadv(Terminally Ill, , "$1-2 Years;1;2-12 Months;2;1 Month;3", -25-x*25, x>0 and x<=3, , Physical)
		$$ladv(Youth, -2/year, , "(age<youth_age)*max(-3,ceil((age-youth_age)/(1+extLifespan)))*2", ,
			!Disadvantages:Age;Info:Age<youth_age, Physical, d_age, "%0ln (^x'age')%-14rc%-7r! ")
			textline editdlg 2
		end

	sublist "Social Disadvantages" memlist
		sublist Appearance sort 1 memlist
			$$nadv(Appearance, appearance+-x, "$Unattractive;1;Ugly;2;Hideous;3;Monstrous;4;Horrific;5",
				"qindex(x,-5,-10,-20,-25,-30)", x>0 and x<=5,
				"!#1,Disadv:Appearance::Only one Appearance allowed;!#1,Adv:Appearance::Appearance Advantage not allowed",
				Social;Appearance, appdisadv, "%0ln (^v)%-14rx'displev(@c@)'%-7r!")
				textline cost -5
				opt exp Reaction "c/5"
					end
			$$appdisadv(Unattractive, 1)
			$$appdisadv(Ugly, 2)
			$$appdisadv(Hideous, 3)
			$$appdisadv(Monstrous, 4)
			$$appdisadv(Horrific, 5)
			end
		$$nadv(Dependent, , "$Competent;1;Average;2;Incompetent;3", "qindex(x,-6,-12,-16)", x>0 and x<=3, , Social, ,
				"%0ln (^v, ^o'Frequency', ^o'Importance')%-14rc%-7r!")
			opt	mult Importance "?:2;Employer/Acquaintance,1/2;Friend,1;Loved One,2"
				mult Frequency "?:2;6 or less,1/2;9 or less,1;12 or less,2;15 or less,3"
				end
		
		$$nadv(Duty, , "$6 or less;1;9 or less;2;12 or less;3;15 or less;4", "qindex(x,-2,-5,-10,-15)", x>0 and x<=4, , Social, , "%0ln (^v)%-14rc%-7r!")
			opt add "Involuntary" "?+0;-5"
				add "Not Dangerous" "?+0;+5"
				end
		$$nadv(Enemy, , "$Individual;1;Powerful Individual;2;Small Group;3;Medium Group;4;Very Powerful Individual;5;Large Group;6;Formidable Group;7",
			"qindex(x,-5,-10,-10,-20,-20,-30,-40)", x>0 and x<=7, , Social)
			textline dupexpected
			opt
				mult "Roll" "?:2;6 or less,1/2;9 or less,1;12 or less,2;15 or less,3"
				add "Unknown" "?+0;-5"
				end
		$$nadv("Odious Personal Habit", , "$Bad;1;Very Bad;2;Disgusting;3", x*-5, x>0 and x<=3, , Social)
			textline dupexpected
			opt	exp Reaction -x
				end
		sublist Poverty sort 1 memlist
			$$cadv(Struggling, -10, "!#1,Adv:Wealth;!#1,Disadv:Poverty", Poverty, , wealthAdd-1)
				opt
					exp "Starting Wealth" "format('$%n',wealthFunc(0))"
					end	
			$$cadv(Poor, -15, "!#1,Adv:Wealth;!#1,Disadv:Poverty", Poverty, , wealthAdd-2)
				opt
					exp "Starting Wealth" "format('$%n',wealthFunc(0))"
					end	
			$$cadv(Dead Broke, -25, "!#1,Adv:Wealth;!#1,Disadv:Poverty", Poverty, , wealthAdd-3)
				opt
					exp "Starting Wealth" "format('$%n',wealthFunc(0))"
					end	
			$$nadv(Poverty, "wealthAdd-x", 
				"$Struggling;1;Poor;2;Dead Broke;3", "qindex(x,-10,-15,-25)", x>0 and x<=3,
				"!#1,Adv:Wealth;!#1,Disadv:Poverty", Poverty)
				textline cost -10
				opt	
					exp "Starting Wealth" "format('$%n',wealthFunc(0))"
					end	
			end
		$$ladv(Primitive, -5, tl-x, , "x>0 and tl-x>=0", , Social, , "%0ln (TL ^o'Effective TL')%-14rc%-7r!")
			opt
				begin exp "Effective TL" tl+&tl noprint end
				end
		$$ladv("Reputation", -5, , , "abs(x)<=4", , Social, , , , -^v, "integer((c+a)*@mo@*(max(100+@p@,25)/100)-(@v@<0?-.0001:.0001))")
			opt exp Reaction -x
				mult "Recognized by" "?:1;Everyone,1;Large class,׽;Small class,1/3"
				mult "Frequency of Recognition" "?:1;All the time,1;Sometimes (10-),׽;Occasionally (7-),1/3 "
				end
		$$nadv(Secret, , "$Serious Embarassment;1;Utter Rejection;2;Imprisonment or Exile;3;Possible Death;4",
			"qindex(x,-5,-10,-20,-30)", x>0 and x<=4, , Social)
			textline dupexpected
		sublist "Social Stigma" memlist
			$$ladv("Social Stigma", -5, , , "x>0 and x<5", , Social Stigma;Social)
			$$cadv(Barbarian, -15, , Social Stigma;Social)
				opt	text Reaction -3
					end
			$$cadv("Minority Group", -10, , Social Stigma;Social)
				opt	text Reaction -2/+2
					end
			$$cadv(Outlaw, -15, , Social Stigma;Social)
				opt	text Reaction -3
					end
			$$cadv(Outsider, -15, , Social Stigma;Social)
				opt	text Reaction -3/+3
					end
			$$cadv("Second Class Citizen", -5, , Social Stigma;Social)
				opt	text Reaction -1
					end
			$$cadv("Valuable Property", -10, , Social Stigma;Social)
			end
		$$ladv("Status", -5, status-x, , "x>0 and x<5", "!Adv:Status", Social, statusDisadv, , , -^v)
		
		end
	sublist "Occult and Paranormal Disadvantages" memlist
		$$cadv(Cursed, -75, , Occult/Paranormal)
		$$ladv(Destiny, -5, , , x>0 and x<4, !Adv:Destiny, Occult/Paranormal)
		$$ladv(Jinxed, -20, , , x>0 and x<4, , Occult/Paranormal)
		$$cadv("Weirdness Magnet", -15, , Occult/Paranormal)
		end
	end
	
cat Equipment
	$$note(--)
		textline rand -1 dupexpected
	$$note(Note)
		textline rand -1
	$$sublist(Sublist, "%0ln%-14r! $(posswtfmt)")
		textline rand -1
	$$sublist("Military Equipment", "%0ln%-14r! $(posswtfmt)")
		textline inheritopts
		textline rand -1
		opt begin text "Military Issue" "?+1;" dispexp 'l' alias "No Cost" noprint end end

sublist "Animals" memlist
	$$animal	Donkey	25	10	4	13	8	1000	500	2 hexes; too small to ride
	$$animal	Small mule	30	10	4	14	8	1000	800	2 hexes; too small to ride
	$$animal	Large mule	40	10	4	14	9	2000	1400
	$$animal	Pony	30	10	4	13	13	1500	800
	$$animal	Racehorse	32	9	4	13	18	4000	1100	Some are faster!
	$$animal	Saddle horse	35	9	4	14	12	1200	1200	Ordinary riding horse
	$$animal	Cavalry horse	40	9	4	15	16	4000	1400	A light warhorse
	$$animal	Heavy warhorse	50	9	4	16	15	5000	1900	Usually vicious
	$$animal	Draft horse	60	9	4	16	12	2000	2000
	$$animal	Ox	80	8	4	17	8	1500	2500
	$$animal	Camel	40	9	4	15	10	1500	1400	Vicious; drinks little
	$$animal	Elephant	300	12	6	17/50	8	10000	12000	10 hexes. PD 1, DR2.
	end
sublist Armor memlist
	sublist "Generic Armor" memlist
		$$armor	Generic Full-Body Armor		1	1	0	0	Body,Arms,Legs,Whole
		$$armor	Generic Torso Armor		1	1	0	0	Body
		$$armor	Generic Arm Armor		1	1	0	0	Arms
		$$armor	Generic Leg Armor		1	1	0	0	Legs
		$$armor	Generic Handwear		1	1	0		Hands
		$$armor	Generic Helmet		1	1	0	0	Head
		end

sublist "Ancient/Medieval Armor" memlist
	sublist Headgear memlist
		$$armor	Cloth Cap		1	1	5	0	Head
		$$armor	Leather Helm		2	2	30	0	Head
		$$armor	Chain Coif		3/1	4/2	55	4	Head
		$$armor	Pot-helm		3	4	100	5	Head
		$$armor	Greathelm		4	7	340	10	Head	Weapons skills at -1, senses at -3
		end
	sublist Torso memlist
		$$armor	Cloth Armor		1	1	30	6	Body
		$$armor	Leather Armor		2	2	100	10	Body
		$$armor	Leather Jacket		1	1	50	4	Body,Arms
		$$armor	Chainmail		3/1	4/2	230	25	Body	Against impaling: PD 1, DR 2
		$$armor	Scale Armor		3	4	420	35	Body
		$$armor	Bronze Breastplate		4	4	400	20	Body
		$$armor	Steel Breastplate		4	5	500	18	Body
		$$armor	Corselet		4	6	1300	35	Body
		$$armor	Heavy Corselet		4	7	2300	45	Body
		end
	sublist "Arms and Legs" memlist
		$$armor	Chainmail Arms		3/1	4/2	70	9	Arms	Against impaling: PD 1, DR 2
		$$armor	Chainmail Legs		3/1	4/2	110	15	Legs	Against impaling: PD 1, DR 2
		$$armor	Cloth Arms		1	1	20	2	Arms
		$$armor	Cloth Legs		1	1	20	2	Legs
		$$armor	Leather Arms		2	2	50	2	Arms
		$$armor	Leather Legs		2	2	60	4	Legs
		$$armor	Scale Arms		3	4	210	14	Arms
		$$armor	Scale Legs		3	4	250	21	Legs
		$$armor	Plate Arms		4	6	1000	15	Arms
		$$armor	Plate Legs		4	6	1100	20	Legs
		$$armor	Heavy Plate Arms		4	7	1500	20	Arms
		$$armor	Heavy Plate Legs		4	7	1600	25	Legs
		end
	Sublist "Hands and Feet" memlist
		$$armor	Cloth Gloves		1	1	15		Hands
		$$armor	Leather Gloves		2	2	30		Hands
		$$armor	Gauntlets		3	4	100	2	Hands
		$$armor	Sandals		0	0	10	1	Feet
		$$armor	Shoes		1	1	40	2	Feet
		$$armor	Generic Footwear		2	2	80	3	Feet
		$$armor	Boots		2	2	80	3	Feet
		$$armor	Sollerets		3	4	150	7	Feet
		end
	sublist "Suits of Armor" memlist
		$$armor	Cloth Armor Suit		1	1	70	10	Body,Arms,Legs,Whole
		$$armor	Leather Armor Suit		2	2	210	16	Body,Arms,Legs,Whole
		$$armor	Light Leather Armor Suit		1	1	210	10	Body,Arms,Legs,Whole
		$$armor	Chainmail Suit		3/1	4/2	410	49	Body,Arms,Legs,Whole
		$$armor	Scale Armor Suit		3	4	880	70	Body,Arms,Legs,Whole
		$$armor	Plate Armor Suit		4	6	3400	70	Body,Arms,Legs,Whole
		$$armor	Heavy Plate Armor Suit		4	7	5400	90	Body,Arms,Legs,Whole
		end
	end
sublist "Basic Combat System" memlist
	$$armor	Summer Clothing		0	0	20	2	Whole
	$$armor	Winter Clothing		0	1	60	5	Body,Head,Arms,Legs,Hands,Feet,Whole
	$$armor	Padded Cloth Armor	1	1	1	180	14	Body,Head,Arms,Legs,Hands,Feet,Whole
	$$armor	Light Leather Armor	1	1	1	210	10	Body,Head,Arms,Legs,Hands,Feet,Whole
	$$armor	Heavy Leather Armor	1	2	2	350	20	Body,Head,Arms,Legs,Hands,Feet,Whole
	$$armor	Chainmail Armor	3	3/1	4/2	550	45	Body,Head,Arms,Legs,Hands,Feet,Whole
	$$armor	Scale Armor	2	3	4	750	50	Body,Head,Arms,Legs,Hands,Feet,Whole
		textline original "BCS Scale Armor"
	$$armor	Half Plate	2	4	5	2000	70	Body,Head,Arms,Legs,Hands,Feet,Whole	All combat skills at -1 due to helm; Vision and Hearing at -3
	$$armor	Light Plate	3	4	6	4000	90	Body,Head,Arms,Legs,Hands,Feet,Whole	All combat skills at -1 due to helm; Vision and Hearing at -3
	$$armor	Heavy Plate	3	4	7	6000	110	Body,Head,Arms,Legs,Hands,Feet,Whole	All combat skills at -1 due to helm; Vision and Hearing at -3
	$$armor	Kevlar (Light)	7	2/1	4/2	220	5	Body,Whole
	$$armor	Kevlar (Heavy)	7	2/1	12/2	420	9	Body,Whole
	$$armor	Light Body Armor	7	4	15	270	22	Body,Head,Arms,Legs,Hands,Feet,Whole
	$$armor	Reflec	8	6	2	320	4	Body,Head,Arms,Legs,Hands,Feet,Whole	vs. lasers only; PD3, DR0 vs. sonics
	$$armor	Medium Body Armor	8	6	25	1520	32	Body,Head,Arms,Legs,Hands,Feet,Whole
	$$armor	Heavy Combat Armor	9	6	50	2520	52	Body,Head,Arms,Legs,Hands,Feet,Whole
	end
sublist "Modern and Ultra-Tech" memlist
	sublist Headgear memlist
		$$armor	British Tin Hat	6	2	4	70	4	Head
		$$armor	German Helmet	6	4	5	60	5	Head
		$$armor	US Army M1 Helmet	6	3	4	30	4	Head
		$$armor	Police Riot Helmet	7	4	5/2	75	3	Head	DR 2 vs. cutting, impaling, bullet
		$$armor	Gentex PASGT Helmet	7	4	5	125	3	Head
		$$armor	Combat Infantry Dress Helmet	8	4	18	300	10	Head	Full face (visor DR 10)
		end
	sublist "Body Armor" memlist
		$$armor	Civil War Body Armor	5	4	10	18	12	Body
		$$armor	Flak Jacket	6	2	4	150	12	Body
		$$armor	Gentex Protective Vest	7	2	5	200	5	Body
		$$armor	EOD PS-820 Torso	7	3	30	400	20	Body	-3 to DX
		$$armor	EOD PS-820 Arms/Legs	7	3	10	100	10	Arms,Legs
		$$armor	EOD PS-820 Head	7	3	20	100	5	Head
		$$armor	Second Chance Hardcorps System	7	2	16	425	16	Body
		$$armor	Second Chance Hardcorps Inserts	7	0	19	380	38	Body
		$$armor	Second Chance Standard	7	2/1	14/2	200	2.5	Body
		$$armor	Combat Infantry Dress Jacket	8	4	40	300	25	Body,Arms,Hands,Whole
		$$armor	Combat Infantry Dress Pants	8	2	12	140	10	Legs
		$$armor	Combat Infantry Dress Boots	8	3	15	70	5	Feet
		end
	end
	end

sublist "Modern and Ultra-Tech Weapons" memlist

	sublist "Automatic Pistols" memlist
		$$gun("AMT Backup", GunsPtl, , cr, 2d, 11, 0, 125, 1467, 1, 3~, 5, 8, -2, 180, 7, "9mm S, US, 1976", Automatic Pistol)
		$$gun("Beretta 92", GunsPtl, , cr, 2d+2, 10, 3, 150, 1867, 2, 3~, 15, 9, -1, 400, 7, "9mm P, IT, 1976", Automatic Pistol)
		$$gun("Blaster", beamweaponsblaster, , imp, 6d, 10, 6, --, 300, 2, 3~, 20/C, 8, -1, 2000, 9, "BW, SF, TL9", Automatic Pistol)
		$$gun("Colt M1911", GunsPtl, , cr, 2d, 10, 2, 175, 1700, 2, 3~, 7, 10, -2, 30, 6, ".45 ACP, US, 1910", Automatic Pistol)
		$$gun("FN HP35", GunsPtl, , cr, 2d+2, 10, 3, 150, 1867, 2, 3~, 13, 9, -1, 80, 6, "9mm P, BE, 1935", Automatic Pistol)
		$$gun("Gauss Needler", gunsneedler, , imp, 1d+2, 10, 4, 100, 300, 1, 12, 100/B, , -1, 2000, 8, ".02 Ne, SF, TL8", Automatic Pistol)
		$$gun("Glock 17", GunsPtl, , cr, 2d+2, 10, 3, 150, 1867, 2, 3~, 17, 9, -1, 450, 7, "9mm P, AU, 1982", Automatic Pistol)
		$$gun("IMI Eagle", GunsPtl, , cr, 3d, 12, 3, 230, 2500, 4, 3~, 9, 12, -3, 750, 7, ".44 M, IS, 1984", Automatic Pistol)
		$$gun("Laser Pistol", beamweaponslaser, , imp, 1d, 9, 7, 400, 500, 2, 4*, 20/C, , 0, 1000, 8, "BW, SF, TL8", Automatic Pistol)
		$$gun("Mauser '96", GunsPtl, , cr, 2d+1, 11, 3, 140, 1800, 2, 3~, 10, 10, -1, 20, 6, "7.63mm Mauser, GE, 1896", Automatic Pistol)
		$$gun("Mauser Luger", GunsPtl, , cr, 2d+2, 9, 4, 175, 1900, 2, 3~, 8, 9, -1, 25, 6, "9mm P, GE, 1904", Automatic Pistol)
		$$gun("Needler", GunsPtl, , imp, 1d+2, 9, 1, 100, 300, 1, 3~, 100, , -1, 800, 8, ".01 Ne, SF, TL8", Automatic Pistol)
		$$gun("Ruger STD", GunsPtl, , cr, 1d+1, 9, 4, 75, 1200, 2, 3~, 9, 7, -1, 25, 6, ".22 LR, US, 1949", Automatic Pistol)
		$$gun("Stunner", beamweaponssonic, , stun, 20-HT min, 10, 3, 12, 20, 1, 3~, 40/C, , 0, 800, 9, "BW, SF, TL9", Automatic Pistol)
		$$gun("Walther PPK", GunsPtl, , cr, 2d-1, 10, 2, 100, 1467, 1, 3~, 7, 8, -1, 75, 6, ".32 ACP, GE, 1929", Automatic Pistol)
		end
	sublist Revolvers memlist
		$$gun("Colt Python", GunsPtl, , cr, 3d-1, 10, 3, 185, 2034, 3, 3~, 6, 10, -2, 100, 7, ".357M, US, 1955", Revolver)
		$$gun("Colt Texas", BPWCLPtl, , cr, 2d-1, 10, 1, 100, 1100, 4, 1, 5, 10, -1, 10, 5, ".34 (BP), US, 1836", Revolver)
		$$gun("Smith & Wesson M10", GunsPtl, , cr, 2d-1, 10, 2, 120, 1934, 2, 3~, 6, 8, -1, 20, 6, ".38 Special, US, 1902", Revolver)
		$$gun("Generic Revolver", GunsPtl, , cr, 2d-1, 10, 2, 120, 1934, 2, 3~, 6, 8, -1, 20, 6, Revolver)
			textline generic
		$$gun("Smith & Wesson M29", GunsPtl, , cr, 3d, 10, 2, 200, 2500, 3, 3~, 6, 11, -3, 100, 7, ".44M, US, 1956", Revolver)
		$$gun("Smith & Wesson Russian", GunsPtl, , cr, 2d, 10, 3, 150, 1700, 2, 1, 6, 10, -2, 20, 5, ".44R, US, 1871", Revolver)
		$$gun("Webley No. 1", GunsPtl, , cr, 2d, 11, 2, 160, 1600, 3, 3~, 6, 11, -3, 40, 5, ".455W, UK, 1877", Revolver)
		end

	sublist "Non-Repeating Pistols" memlist
		$$gun("Flintlock Pistol", BPWFLPtl, , cr, 2d-1, 11, 1, 75, 467, 3, 1/20, 1, 10, -1, 200, 5, ".51 (BP), Eur., 18c.", Black Powder Weapon)
		$$gun("Wheellock Pistol", BPWWLPtl, , cr, 1d+1, 13, 1, 75, 400, 3, 1/60, 1, 10, -1, 700, 4, ".60 (BP), Eur., 17c.", Black Powder Weapon)
		$$gun("Wogdon Pistol", BPWFLPtl, , cr, 2d-1, 10, 3, 75, 467, 2, 1/20, 1, 9, -1, 20, 5, ".45 (BP), UK, 1800", Black Powder Weapon)
		$$gun("Generic Non-Repeating Pistol", BPWFLPtl, , cr, 2d-1, 10, 3, 75, 467, 2, 1/20, 1, 9, -1, 20, 5, Black Powder Weapon)
			textline generic
		end
	sublist Shotguns memlist
		$$gun("Blunderbuss 8G", BPWFLShg, , cr, 5d, 14, 3, 15, 100, 12, 1/15, 1, 13, -4, 15, 5, "Shot (BP), UK, 16c.", Black Powder Weapon;Shotgun)
		$$gun("Ithaca 10G", GunsShg, , cr, 5d, 12, 5, 25, 150, 10, 2~, 2, 13, -4, 45, 6, "Shot, US, 1900", Shotgun)
		$$gun("Remington M870", GunsShg, , cr, 4d, 12, 5, 25, 150, 8, 3~, 5, 12, -3, 235, 7, "12G, US, 1950", Shotgun)
		end
	sublist Rifles memlist
		$$gun("Baker Rifle", BPWFLRfl, , cr, 4d, 15, 7, 300, 2500, 9, 1/20, 1, 12, -3, 20, 5, ".625 (BP), UK, 1790", Rifle)
		$$gun("Brown Bess", BPWFLMsk, , cr, 3d, 15, 5, 100, 1500, 13, 1/15, 1, 11, -3, 10, 5, ".75 (BP), UK, 1720", Rifle)
		$$gun("Cannon Lock", BPWHnG, , cr, 2d, 20, 1, 100, 600, 5, 1/60, 1, 10, -3, 300, 4, ".90 (BP), Eur., 16c.", Rifle)
		$$gun("Enfield '53", BPWCLRfl, , cr, 3d, 15, 8, 700, 2100, 8, 1/15, 1, 10, -2, 15, 5, ".577 (BP), UK, 1853", Rifle)
		$$gun("Ferguson Rifle", BPWFLRfl, , cr, 4d, 14, 7, 400, 3700, 7, 1/10, 1, 10, -2, 60, 5, ".60 (BP), UK, 1777", Rifle)
		$$gun("Kentucky Rifle", BPWFLRfl, , cr, 4d, 15, 7, 400, 3700, 6, 1/20, 1, 10, -2, 40, 5, ".45 (BP), US, 1750", Rifle)
		$$gun("Lebel '86", GunsRfl, , cr, 6d+1, 15, 10, 1000, 3900, 10, 1/2, 8, 12, -3, 125, 5, "8mm L, FR, 1876", Rifle)
		$$gun("Martini Henry '71", GunsRfl, , cr, 4d, 15, 7, 600, 2030, 6, 1/4, 1, 10, -2, 20, 5, ".45 Br, UK, 1871", Rifle)
		$$gun("Matchlock Musket", BPWMLMsk, , cr, 4d, 18, 2, 100, 600, 20, 1/60, 1, 12, -2, 400, 4, ".80 (BP), Eur., 17c.", Rifle)
		$$gun("Mauser 98k", GunsRfl, , cr, 7d, 14, 11, 1000, 3972, 9, 1/2, 5, 12, -3, 170, 6, "8mm Mauser, GE, 1898", Rifle)
		$$gun("Remington Rifle", GunsRfl, , cr, 4d, 15, 8, 700, 2100, 9, 1/4, 1, 10, -2, 55, 5, ".45 C, US, 1871", Rifle)
		$$gun("Sharps 50", GunsRfl, , cr, 6d, 15, 7, 600, 3300, 11, 1/4, 1, 12, -3, 150, 5, ".50-90, US, 1890", Rifle)
		$$gun("Springfield 73", GunsRfl, , cr, 4d, 15, 8, 700, 2100, 9, 1/4, 1, 11, -2, 20, 5, ".45-70, US, 1873", Rifle)
		$$gun("Winchester '73", GunsRfl, , cr, 3d, 13, 7, 300, 2200, 7.1, 2~, 6, 10, -2, 40, 5, ".44-40, US, 1873", Rifle)
		$$gun("Winchester '94", GunsRfl, , cr, 5d, 13, 8, 450, 3011, 7, 2~, 6, 10, -1, 475, 5, ".30-30 Winchester, US, 1894", Rifle)

		$$rifle("Lee-Enfield Mk3#1", ".303 Br, UK, 1903", cr, 6d+1, 14, 10, 1000, 3800, 10.2, 1, 10, 12, -2, 130, 6)
		$$rifle	M1903A1	.30-06, US, 1906	cr	7d+1	14	11	1000	3710	9.5	1/2	5	12	-3	135	6

		$$rifle	Generic Rifle		cr	7d+1	14	11	1000	3710	9.5	1/2	5	12	-3	135	6
			textline generic

		$$rifle	H&H Nitro Express	.600 N, UK, 1923	cr	10d	16	7	1500	5063	16	2	2	13	-6	200	6
		$$rifle	M1 Garand	.30-06, US, 1936	cr	7d+1	14	11	1000	3710	10	3~	8	12	-3	590	6
		$$rifle	AK-47	7.62mm R, SU, 1949	cr	5d+1	12	7	400	3011	10.5	10*	30	10	-1	290	7
		$$rifle	FN-FAL	.308 Win, 1950, BE	cr	7d	14	11	1000	4655	11	11*	20	11	-2	900	7
		$$rifle	H&K G3	.308 Win, 1959, GE	cr	7d	14	10	1000	4655	11	10*	20	11	-2	550	7
		$$rifle	M16	.223 Rem, 1964, US	cr	5d	12	11	500	3843	8	12*	20	9	-1	540	7
		$$rifle	Steyr AUG	.223 Rem, 1978, AU	cr	5d	11	10	500	3843	9	11*	30	9	-1	540	7
		$$rifle	H&K PSG1	.308 Win, 1982, GE	cr	7d	15	13	1200	4655	11	3~	20	12	-2	4500	7
		$$rifle	Needle Rifle	.01 Ne, SF	imp	2d	13	9	300	800	5	3~	100	8	-1	1200	8
		$$rifle	Gauss Needle Rifle	.02 GN, SF	imp	2d+1	14	11	500	1000	6	20*	100/B	9	-1	2500	8
		$$gun	Laser Rifle	BeamWeaponsLaser		imp	2d	15	13	900	1200	5	3~	12/C		0	2000	8	SF (BW)	Rifle
		$$gun	Military Laser Rifle	BeamWeaponsLaser		imp	2d	12	15	1500	2000	9	8*	140/D		0	4000	8	SF (BW)	Rifle
		$$gun	Blast Rifle	BeamWeaponsBlaster		imp	12d	14	13	400	800	10	3~	12/C	9	-1	3000	9	SF (BW)	Rifle
		$$gun	Disruptor	BeamWeaponsDisruptor		imp	6d	13	10	500	1000	9	3~	20/C		0	2500	9	SF (BW)	Rifle
		$$gun	Stun Rifle	BeamWeaponsSonic		stun	20-HT min	12	10	300	1000	4	3~	20/C		0	1000	9	SF (BW)	Rifle
		end

	sublist "Submachine Guns" memlist
		$$gun	Bergmann MP18 Submachine Gun	GunsLtAu		cr	3d-1	11	7	160	1900	9	9*	32	10	-1	50	6	9mm P, 1918, GE	Submachine Gun
		$$gun	Thompson Submachine Gun	GunsLtAu		cr	2d+1	11	7	190	1750	12	20*	30	11	-3	120	6	.45 ACP, US, 1922	Submachine Gun

		$$gun	Generic Submachine Gun	GunsLtAu		cr	2d+1	11	7	190	1750	12	20*	30	11	-3	120	6	Submachine Gun
			textline generic

		$$gun	MP40 Submachine Gun	GunsLtAu		cr	3d-1	10	6	160	1900	10.5	8	32	10	-1	70	6	9mm P, 1940, GE	Submachine Gun
		$$gun	Sten Submachine Gun	GunsLtAu		cr	3d-1	11	6	160	1900	9	9*	32	10	-1	10	6	9mm P, 1940, GB	Submachine Gun
		$$gun	PPSh41 Submachine Gun	GunsLtAu		cr	3d-1	10	6	160	1900	12	16	71	10	-1	65	6	7.62 RP, 1941, USSR	Submachine Gun
		$$gun	IMI Uzi Submachine Gun	GunsLtAu		cr	3d-1	10	7	160	1900	9.5	10*	32	10	-1	150	7	9mm P, 1952, IS	Submachine Gun
		$$gun	H&K MP5 Submachine Gun	GunsLtAu		cr	3d-1	10	8	160	1900	7.25	10*	30	10	-1	340	7	9mm P, 1966, GE	Submachine Gun
		end

	sublist "Grenades" memlist
		$$grenade	Mk 2 Defensive Grenade	cr	2d-1	1.5	3-5	10	6	US
		$$grenade	Mk 67 Defensive Grenade	cr	5d+2	1	4-5	25	7	US
		$$grenade	Mk 68 Defensive Grenade	cr	5d+2	1	impact	20	7	US
		$$grenade	AN-M8 Smoke Grenade	--	--	1.5	1-2	15	7	US
		$$grenade	M59 Offensive Grenade	cr	5d+2	1.5	impact	15	7	US
		$$grenade	No. 36 Defensive Grenade	cr	2d-1	1.5	3-5	10	6	UK
		$$grenade	\"Jam Tin\" Grenade	cr	5d	1.5	0-8	5	6	UK
		$$grenade	\"Potato Masher\" Grenade	cr	2d-2	1.3	2-4	10	6	GE
		$$grenade	RGD-5 Defensive Grenade	cr	3d-1	.6	3-4	20	7	USSR
		end
	sublist Ammunition memlist
		$$ammo("22 LR Ammunition (20 c.)", 1, 2, 1, 1, 100, 6)
		$$equip("Gauss Needles", 1, 25, Ammunition, , 8)
			opt text DMG 1 text "Damage Mod." 1 exp Rounds 100*max(1,`Quantity`)  end

		$$ammo("Military Rifle Ammunition (20 c.)", 1, 10, 1, 1, 100, 6)

		$$equip("Needles", 1, 15, Ammunition, , 8)
			opt  text DMG 1 text "Damage Mod." 1 exp Rounds 100*max(1,`Quantity`) end

		$$ammo("Pistol Ammunition (.40+ caliber)", 1, 40, 1, 1.5, 100, 6)
		$$ammo("Pistol Ammunition (TL6+)", 1, 20, 1, 1, 100, 6)
		$$ammo("Rifle Ammunition (20 c.)", 1, 30, 1, 1, 100, 6)
		$$equip("Ammunition (TL5-)", 1, 2, Ammunition, , 3)
			opt text DMG 1 text "Damage Mod." 1.5 exp Rounds 100*max(1,`Quantity`)  end
		end
	end

sublist "Fantasy/Medieval Equipment" memlist
	sublist Food memlist
		$$equip("Brandy (quart)", 2, 15)
		$$equip("Traveller's rations", 0.5, 2, , One meal)
		$$equip("Water (gallon)", 8, 0)
		$$equip("Water (quart)", 2, 0)
		$$equip("Wine (quart)", 2, 2)
		end
	sublist "Medical Gear" memlist
		$$equip("Crash Kit", 10, 100, Medical Equipment)
			opt  exp Skill max(firstaid,physician,mx(iq)-5,veterinary-5,physiology-5)+2
			end
		$$equip("Doctor's Black Bag", 15, 300, Medical Equipment, Surgery Skill Bonus: +2)
			opt exp "Skill (First Aid)" max(firstaid,physician,mx(iq)-5,veterinary-5,physiology-5)+2 
				end
		$$equip("First Aid Kit", 2, 30, Medical Equipment)
			opt  exp Skill max(firstaid,physician,mx(iq)-5,veterinary-5,physiology-5)+1
				end
		end
	sublist "Climbing Equipment" memlist
		$$rope	Cable	17	100	10	1.5\"	3700
		$$rope	Cord	0.5	1	10	3/16\"	90
		$$rope	Rope	1.5	5	10	3/8\"	300
		$$rope	Heavy rope	5	25	10	3/4\"	1100
		$$equip("Iron spike", 0.5, 1)
		$$equip("Grapnel hook", 2, 20, , Supports 300 lbs)
		end
	sublist "Thieving Equipment" memlist
		$$equip("Lockpicks", 0, 30, Thieving Equipment)
			opt exp "Skill" "max(lockpicking,iq-5)" end
		$$equip("Lockpicks (good)", 0, 200, Thieving Equipment)
			opt exp "Skill" "max(lockpicking,iq-5)+1" end
		end
	sublist Tools 
		memlist 
		$$equip	Six-foot pole	3	5			
		$$equip	Pick	8	16
		$$equip	Shovel	6	30
		$$equip	Crowbar	10	8		5 ft. long, iron
		$$equip	Hammer	4	14		Small sledge
		$$equip	Hatchet (wood chopping)	2	20		
		end
	 
	sublist "Outdoor Equipment" memlist
		sublist Basics memlist
			$$equip	Group basics	20	50		Pots, pans, etc.
			$$equip	Personal basics	0	5		Cup, spoon, towel, flint, steel, towel, etc.
			end
		sublist "Camping Equipment" memlist
			$$equip("Blanket (heavy wool)", 5, 20)
			$$equip("Fishing net", 10, 30)
			$$equip("Lantern", 2, 20)
			$$equip("Oil", 1, 2, , 1 pint burns 24 hours)
			$$equip("Sleeping bag", 15, 100, , for freezing weather)
			$$equip("Tent (four-person)", 30, 150, , Requires two 6-foot poles)
			$$equip("Tent (one-person)", 5, 50, , Includes ropes)
			$$equip("Tent (two-person)", 12, 80, , Requires 6-foot pole)
			$$equip	Tent (twenty-person)	100	300		Requires 16 6-foot poles
			$$equip("Torch", 1, 3, , 1 hour)
			$$equip("Whetstone", 1, 5)
			end
		sublist Containers memlist
			$$equip("Five-gallon wineskin", 1, 30)
			$$equip("Gallon ceramic bottle", 4, 5)
			$$equip("Gallon wineskin", 0.25, 10)
			$$equip("Quart ceramic bottle", 1, 3)
			$$equip("Quart ceramic bottle", 1, 3)
			end
		sublist "Packs and Pouches" memlist
			$$sublist(Backpack Contents, "%0ln%-14r! $(posswtfmt)")
				textline rand -1
			$$equip("Backpack (large)", 10, 100, , With frame; holds 100 lbs)
			$$equip("Pouch (large)", 1, 30, , Holds 10 lbs)
			$$equip("Backpack (small)", 3, 60, , Holds 40 lbs)
			$$equip("Pouch (small)", 0, 10, , Holds 3 lbs)
			end
		end
	sublist "Riding and Transportation" memlist
		$$vehicle("Canoe", 100, 300, , Carries up to 600 lbs)
		$$vehicle("Rowboat", 300, 500, , Carries up to 1000 lbs)
		$$vehicle("Saddle, bit and bridle", 20, 150)
		$$vehicle("Wagon (four-horse)", 800, 1000, , Carries up to 4 tons)
		$$vehicle("Wagon (one-horse)", 300, 400, , Carries up to 1 ton)
		$$vehicle("Wagon (two-horse)", 500, 700, , Carries up to 2 tons)
		$$vehicle("Wagon (ox team)", 1200, 1500, , Carries up to 10 tons)
		end
	end


# Modern equipment for GURPS Basic. The PLUGIN is set to a non-blank
# value because there are several items with the same name, and the
# plugin define will serve to disambiguate the items during conversions.

$$define PLUGIN GBRM

sublist "Modern Equipment" memlist
	sublist Food 
		memlist 
		$$equip	Meal (low-quality)		3.50	Food		6
		$$equip	Meal (average-quality)		7.50	Food		6
		$$equip	Meal (high-quality)		25	Food		6
		$$equip	Liquor (cheap bottle)		10	Food		6
		$$equip	Liquor (good bottle)		20	Food		6
		$$equip	Rations (concentrated)	2	50	Food	One week	6
		end 
	sublist "Medical Gear" memlist
		$$equip("Crash Kit", 10, 100, Medical Equipment, , 6)
			opt  exp Skill max(firstaid,physician,mx(iq)-5,veterinary-5,physiology-5)+2
			end
		$$equip("Doctor's Black Bag", 15, 300, Medical Equipment, Surgery Skill Bonus: +2, 6)
			opt exp "Skill (First Aid)" max(firstaid,physician,mx(iq)-5,veterinary-5,physiology-5)+2 
				end
		$$equip("First Aid Kit", 2, 30, Medical Equipment, , 6)
			opt  exp Skill max(firstaid,physician,mx(iq)-5,veterinary-5,physiology-5)+1
				end
		end
	sublist "Climbing" memlist
		$$rope	Cable	17	100	10	1.5\"	3700	6
		$$rope	Cord	0.5	1	10	3/16\"	90	6
		$$rope	Rope	1.5	5	10	3/8\"	300	6
		$$rope	Heavy rope	5	25	10	3/4\"	1100	6
		$$equip("Iron spike", 0.5, 1, , , 6)
		$$equip("Grapnel hook", 2, 20, , Supports 300 lbs, 6)
		end
	sublist "Thieving Tools" memlist
		$$equip("Lockpicks", 0, 30, Thieving Equipment, , 6)
			opt exp "Skill" "max(lockpicking,iq-5)" end
		$$equip("Lockpicks (good)", 0, 200, Thieving Equipment, , 6)
			opt exp "Skill" "max(lockpicking,iq-5)+1" end
		$$equip	Handcuffs	1	50	Thieving Equipment		6
		end
	sublist Tools 
		memlist 
		$$equip	Crowbar	3	8	Tool	3 ft long, iron	6
		$$equip	Cutting Torch	7	75	Tool		6
		$$equip	Cutting Torch Gas Bottles	20	20	Tool		6
		$$equip	Hammer	4	12	Tool	small sledge	6
		$$equip	Pick	8	16	Tool	for digging	6
		$$equip	Shovel	6	12	Tool		6
		$$equip	Swiss Army Knife		25	Tool	-3 if only tool mechanic has	6
		$$equip	Tool Kit	40	600	Tool		6
		end 
	sublist "Outdoor Equipment" 
		memlist 
		$$equip	Personal Basics		5		Spoon, fork, cup, matches, towel, soap, toothbrush, etc.	6
		$$equip	Group Basics	20	50		Pots, rope, hatchet, etc.	6
		$$equip	Backpack	10	100	Pack	With frame, holds 100 lbs	6
		$$equip	Battery		1			6
		$$equip	Binoculars (2.5)	2	40			6
		$$equip	Binoculars (7)	3	400			6
		$$equip	Canteen	1	10		Holds 1 quart	6
		$$equip	Electric Lantern	2	30			6
		$$equip	Fishing Gear	7	25		Rod, reel, tackle	6
		$$equip	Flashlight	1	10		Requires 3 batteries	6
		$$equip	Flashlight (heavy)	3	50		Requires 3 batteries, serves as baton	6
		$$equip	Gun Cleaning Kit	1	20			4
		$$equip	Sleeping Bag	7	25		For normal conditions	6
		$$equip	Sleeping Bag (heavy)	15	100		For freezing conditions	6
		$$equip	Knife (survival)	1.5	40		Handle contains survival equipment	6
		$$equip	Tent (2 people)	5	80		Includes ropes and poles	6
		$$equip	Tent (4 people)	12	150		Includes ropes and poles	6
		$$equip	Watch		25			6
		$$equip	Whetstone		10			6
		end 
	sublist Transportation 
		memlist 
		$$vehicle	Bicycle		60			6
		$$vehicle	Used Car		500			6
		$$vehicle	New Car		6000			6
		$$vehicle	Fancy New Car		25000			6
		$$vehicle	Private Plane (prop-driven)		80000			6
		$$equip	Gasoline (gallon)	8	1			6
		end 
	sublist Communications 
		memlist 
		$$equip	Walkie-talkie	3	75	Communications	Range 2 miles	6
		$$equip	Headset Communicator	.5	20	Communications	Range 1/4 mile	7
		$$equip	Transistor Radio	.5	15	Communications	Needs 1 battery	7
		$$equip	Miniature Short Wave Radio	1	70	Communications	Needs 3 batteries	7
		$$equip	Miniature Color Television	3	200	Communications	Needs 6 batteries	7
		end 
	end

$$define PLUGIN 

sublist Clothing memlist
	sublist "Fantasy/Medieval" memlist
		$$clothing("Breeches (Woolen)", 1, 5, 0, 0)
		$$clothing("Cloak (Lower-class Light)", 2, 10, 0, 0)
		$$clothing("Cloak (Middle-class Light)", 2, 40, 0, 0)
		$$clothing("Cloak (Noble-class Light)", 2, 1000, 0, 0)
		$$clothing("Cloak (Upper-class Light)", 2, 200, 0, 0)
		$$clothing("Clothing (Lower-class)", 1, 10, 0, 0)
		$$clothing("Clothing (Middle-class)", 1, 40, 0, 0)
		$$clothing("Clothing (Upper-class)", 1, 200, 0, 0)
		$$clothing("Dress (Noble)", 1, 1000, 0, 0)
		$$clothing("Peasant Rags", 1, 2, 0, 0)
		$$clothing("Heavy Cloak (Lower-class)", 4, 20, 0, 1)
		$$clothing("Heavy Cloak (Middle-class)", 5, 80, 0, 1)
		$$clothing("Heavy Cloak (Noble-class)", 5, 2000, 0, 1)
		$$clothing("Heavy Cloak (Upper-class)", 5, 400, 0, 1)
		$$clothing("Winter Clothes (Lower-class)", 3, 20, 0, 1)
		$$clothing("Winter Clothes (Middle-class)", 3, 80, 0, 1)
		$$clothing("Winter Clothes (Noble-class)", 3, 2000, 0, 1)
		$$clothing("Winter Clothes (Upper-class)", 3, 400, 0, 1)
		$$clothing("Winter Rags (Peasant)", 3, 4, 0, 1)
		end
	sublist Footwear memlist
		$$see(Boots, "%-20r!$80%-7r!3")
		$$equip("Lower class shoes", 2.5, 10, Footwear)
		$$equip("Sandals", 1, 10, Footwear)
		$$equip("Shoes", 2, 40, Footwear)
		$$equip("Slippers", 1, 10, Footwear)
		end
	end
sublist Generic 
		textline rand -1
	memlist
	$$equip("Generic Possession", 0, 0)
		textline rand -1 generic
	end

sublist "Hand Weapons" memlist
	$$handweapon(Hatchet, "axemace,dx-5", cut sw, 1, 40, 2, 7, Throwable. 1 turn to ready.)
	$$handweapon(Axe, "axemace,dx-5", cut sw+2, 1, 50, 4, 12, 1 turn to ready.)
	$$handweapon(Throwing Axe, "axemace,dx-5", cut sw+2, 1, 60, 4, 11, Throwable. 1 turn to ready.)
	$$handweapon(Small mace, "axemace,dx-5", cr sw+2, 1, 35, 3, 11, 1 turn to ready.)
	$$handweapon(Mace, "axemace,dx-5", cr sw+3, 1, 50, 5, 12, 1 turn to ready.)
	$$handweapon(Pick, "axemace,dx-5", imp sw+1, 1, 70, 3, 11, 1 turn to ready. May get stuck.)

	$$handweapon(Blackjack, "blackjack,dx-4", cr thr, C, 20, 1, 7, May not parry, 0)

	$$sword(Generic Sword, , , , 600, 3)
		opt
			begin 
				exp Damage "format('cut %s; imp %s', sw(`Swing Adds`+`Extra Damage`+qindex(`Weapon Quality`,0,0,1,2)), thr(`Thrust Adds`+`Extra Damage`+qindex(`Weapon Quality`,0,0,1,2)))"
				keepold
				end
			begin text "Swing Adds" ??0;0;x noprint end
			begin text "Thrust Adds" ??0;0;x noprint end
			begin exp Skill "max(broadsword,dx-5,~shortsword)+`Extra Accuracy`" keepold end
			begin text Reach "1; 1" keepold end
			begin exp Parry "integer(`Skill`/2)+wpbonus(0)" keepold end
			end

	$$handweapon(Generic Hand Weapon, , , , 100, 3)
		opt
			begin 
				exp Damage "format('cut %s; imp %s', sw(`Swing Adds`+`Extra Damage`+qindex(`Weapon Quality`,0,0,1,2)), thr(`Thrust Adds`+`Extra Damage`+qindex(`Weapon Quality`,0,0,1,2)))"
				keepold
				end
			begin exp Skill "max(axemace,dx-5)+`Extra Accuracy`" keepold end
			begin text "Swing Adds" ??0;0;x noprint end
			begin text "Thrust Adds" ??0;0;x noprint end
			begin text Reach "1; 1" keepold end
			begin exp Parry "integer(`Skill`/2)+wpbonus(0)" keepold end
			end

	$$sword(Broadsword, "broadsword,dx-5,~shortsword-2,~forcesword-3", cut sw+1;cr thr+1, 1; 1, 500, 3, 10)
	$$sword("Broadsword (thrusting)", "broadsword,dx-5,~shortsword-2,~forcesword-3", cut sw+1;imp thr+2, 1; 1, 600, 3, 10)
	$$sword(Bastard Sword, "broadsword,dx-5,~shortsword-2,~forcesword-3", cut sw+1;cr thr+1, "1,2; 2", 650, 5, 11, 1 turn to ready after swing.)
	$$sword("Bastard Sword (thrusting)", "broadsword,dx-5,~shortsword-2,~forcesword-3", cut sw+1;imp thr+2, "1,2; 2", 750, 5, 11, 1 turn to ready after swing.)
	$$handweapon(Light club, "broadsword,dx-5,~shortsword-2,~forcesword-3", cr sw+1, 1, 10, 3, 10)

	$$sword(Smallsword, "fencing,fencingsmallsword,dx-5", imp thr+1 1d+1, 1, 400, 1, , , "(fencing+fencingsmallsword?2/3:.5)")
	$$sword(Rapier, "fencing,fencingrapier,dx-5", imp thr+1 1d+1, "1,2", 500, 1.5, , , "(fencing+fencingrapier?2/3:.5)")
	$$sword(Saber, "fencing,fencingsaber,dx-5", cut sw;imp thr+1 1d+2, 1; 1, 700, 2, 7, , "(fencing+fencingsaber?2/3:.5)")

	$$handweapon(Morningstar, "flail,dx-6", cr sw+3, 1, 80, 6, 12, 1 turn to ready.)
	$$handweapon(Flail, "flail,dx-6", cr sw+4, "1,2", 100, 8, 13, 2-handed. 1 turn to ready.)

	$$handweapon("Knife (large)", "knife,dx-4", cut sw-2 1d+2;imp thr 1d+2, "C, 1;C", 40, 1, , , 1/2-1)
	$$handweapon("Knife (small)", "knife,dx-4", cut sw-3 1d+1;imp thr-1 1d+1, "C, 1;C", 30, .5, , , 1/2-1)
	$$handweapon(Dagger, "knife,dx-4", imp thr-1 1d+0, C, 20, .25, , , 1/2-1)

	$$handweapon(Lance, "lance,dx-6,(riding>=slc(12)?~spear-3:dx-6)", imp thr+3, 4, 60, 6, 12, May not parry, 0)

	$$handweapon(Glaive, "polearm,dx-5", cut sw+3; imp thr+3, "2, 3;1-3", 100, 8, 11, "2 turns to ready, 1 after thrust")
	$$handweapon(Poleaxe, "polearm,dx-5", cut sw+4; cr sw+4, "2, 3; 2, 3", 120, 10, 12, 2 turns to ready after swing)
	$$handweapon(Halberd, "polearm,dx-5", cut sw+5; imp sw+4; imp thr+3, "2, 3; 2, 3; 1-3", 150, 12, 13, 2 turns to ready after swing)

	$$sword(Shortsword, "shortsword,dx-5,~broadsword-2,~forcesword-3", cut sw; imp thr, 1; 1, 400, 2, 7)
	$$handweapon(Baton, "shortsword,dx-5,~broadsword-2,~forcesword-3", cr sw; cr thr, 1; 1, 20, 1, 7)

	$$handweapon(Javelin, "spear,dx-5,~staff-2", imp thr+1, 1, 30, 2, , Primarily for throwing)
	$$handweapon(Spear, "spear,dx-5,~staff-2", imp thr+2; imp thr+3, "1; 1, 2", 40, 4, 9, One- and two-handed use)
	$$handweapon(Quarterstaff, "staff,dx-5,~spear-2", cr sw+2; cr thr+2, "1, 2; 1, 2", 10, 4, 6, , 2/3)
	$$handweapon(Great axe, "twohandedaxemace,dx-5", cut sw+3, "1, 2", 100, 8, 13, "Two hands, 1 turn to ready")
	$$handweapon(Warhammer, "twohandedaxemace,dx-5", imp sw+3, "1, 2", 100, 7, 13, "Two hands, 1 turn to ready. May get stuck.")
	$$handweapon(Maul, "twohandedaxemace,dx-5", cr sw+4, "1, 2", 80, 12, 14, "Two hands, 1 turn to ready")
	$$handweapon(Scythe, "twohandedaxemace,dx-5", cut sw+2; imp sw, 1; 1, 15, 5, 12, 2-handed. 1 turn to ready.)

	$$sword("Bastard Sword (2-handed)", "twohandedsword,dx-5,~forcesword-3", cut sw+2; cr thr+2, "1, 2; 2", 650, 5, 10, Used two-handed. Blunt point)
	$$sword("Bastard Sword (thrusting, 2-handed)", "twohandedsword,dx-5,~forcesword-3", cut sw+2; imp thr+3, "1, 2; 2", 750, 5, 10, Used two-handed)
	$$sword(Greatsword, "twohandedsword,dx-5,~forcesword-3", cut sw+3; cr thr+2, "1, 2; 2", 800, 7, 12, Blunt point)
	$$sword("Greatsword (thrusting)", "twohandedsword,dx-5,~forcesword-3", cut sw+3; imp thr+3, "1, 2; 2", 900, 7, 12)
	$$sword("Quarterstaff (sword tech.)", "twohandedsword,dx-5,~forcesword-3", cr sw+2; cr thr+1, "1, 2; 2", 10, 4, 9, Using sword technique)

	$$handweapon(Whip, whip, cr sw-2 1d-1, 1-7, 20/yd, 2/yd, 10, $20/yd)

	sublist "SF Melee Weapons" memlist
		$$sword(Force Sword, "forcesword,mx(dx)-5,~broadsword-3,~shortsword-3", , "1; 1", 3000, 2)
			prereq "Configuration:TL>=11-&tl"
			opt	text "Damage" "imp 4d; cut 8d"
				end
		end
	end

sublist "Magic Items" memlist
	$$item(Powerstone)
		textline editdlg 2
		textline format "%0ln (Strength ^o'Strength'^x|dquan(`Quantity`,0)|)%-20rx|`No Cost`?'--':dm(`Price`)|%-7rx|dew(@c@)|"
		textline sformat "%0ln%-16r!$Var%-7r!0"
		textline adj "posscost+`Price`"
		opt begin text Strength "??1;1;x;x>0;Strength must be greater than 0" noprint end
			begin exp Price "(`Quantity`>1?`Quantity`:1)*(`No Cost`=0)*integer(round((10.*`Strength`*`Strength`+70*`Strength`)/0.981^(`Strength`-1))/5*(1+`Markup`/100))*5." dispexp "format('l: %s',`No Cost`?'--':dm(o))" noprint end
			begin text Markup ??92 dispexp "'l: t%'" noprint end
			end
	end

sublist "Missile Weapons" memlist
	$$missile("Hatchet (thrown)", "axethrowing,throwing,dx-4", cut sw, 11, 1, ST1, ST2, 40, 2, 7)
	$$missile("Axe (Throwing)", "axethrowing,throwing,dx-4", cut sw+2, 10, 2, ST, ST1, 60, 4, 11)
	$$missile(Blowpipe, "blowpipe,dx-6", spec thr, 10, 1, , ST4, 30, 1)
	$$missile(Bolas, "bolas", spec thr-1, 12, 0, , ST3, 20, 2)
	$$missile(Short Bow, "bow,dx-6", imp thr 1d+3, 12, 1, ST10, ST15, 50, 2, 7)
	$$missile(Regular Bow, "bow,dx-6", imp thr+1 1d+4, 13, 2, ST15, ST20, 100, 2, 10)
	$$missile(Long Bow, "bow,dx-6", imp thr+2 1d+4, 15, 3, ST15, ST20, 200, 3, 11)
	$$missile(Composite Bow, "bow,dx-6", imp thr+3 1d+4, 14, 3, ST20, ST25, 900, 4, 11)
	$$equip(Quiver, .5, 10)

	$$crossbow	Light Crossbow	8	crossbow,dx-4	imp	12	4	`ST`*20	`ST`*25	150	6
	$$crossbow	Crossbow	10	crossbow,dx-4	imp	12	4	`ST`*20	`ST`*25	150	6
	$$crossbow	Heavy Crossbow	16	crossbow,dx-4	imp	12	4	`ST`*20	`ST`*25	150	6
	$$crossbow	Prodd	10	crossbow,dx-4	cr	12	4	`ST`*20	`ST`*25	150	6
	$$crossbow	Light Prodd	8	crossbow,dx-4	cr	12	4	`ST`*20	`ST`*25	150	6
	$$crossbow	Heavy Prodd	16	crossbow,dx-4	cr	12	4	`ST`*20	`ST`*25	150	6

	$$equip	Goat's-foot	2	50		+5 ST for loading crossbow
	$$missile	Knife (large, thrown)	knifethrowing,throwing,dx-4	imp thr 1d+2	12	0	ST-2	ST+5	40	1
	$$missile	Knife (small, thrown)	knifethrowing,throwing,dx-4	imp thr 1d-1	11	0	ST-5	ST	30	.5
	$$missile	Dagger (thrown)	knifethrowing,throwing,dx-4	imp thr 1d-1	12	0	ST-5	ST	20	.25		

	$$missile	Lasso		Spec thr	16	0			40	3		
	$$missile	Net (large)		Spec thr	13	1		integer(ST/2)+integer(net/5)	40	20		
	$$missile	Melee Net		Spec thr	12	1		ST/2+integer(net/5)	20	5		

	$$missile	Sling	sling,dx-6	cr sw	12	0	ST6	ST10	10	.5		Fires rocks
	$$missile	Staff Sling	sling,dx-6	cr sw+1	14	1	ST10	ST15	20	2		Fires rocks
	$$equip	Atlatl	2	20
	$$missile	Atlatl Dart	dx-4,~spearthrowing-4	imp sw-1	11	1	ST3	ST4	20	1		+5 ST
	$$missile	Atlatl Javelin	dx-4,~spearthrowing-4	imp sw+1	11	3	ST2	ST3	30	2	7	+5 ST
	$$missile	Atlatl Spear	dx-4,~spearthrowing-4	imp sw+3	12	2	ST1	ST2	40	4	9	+5 ST
	$$missile	Generic Missile Weapon	dx-4,throwing,~spearthrowing-4	imp sw+3	12	2	ST1	ST2	40	4	9	+5 ST
	$$missile	Javelin (thrown)	spearthrowing,throwing,dx-4,~spearthrower-4	imp thr+1	10	3	ST1	ST2	30	2	7	
	$$missile	Spear (thrown)	spearthrowing,throwing,dx-4,~spearthrower-4	imp thr+3	11	2	ST	ST1	40	4	9	
	$$missile	Rock	dx-3,throwing	cr thr-1	12	0	ST2	ST3	0	1		
	$$missile	Oil Flask	dx-3,throwing	Spec thr	13	0		ST3	50	1		

	$$equip("Arrow", 0.125, 2, Missile Weapon)
		opt
			begin mult Quantity "??1;1;x;x>0" noprint end
			end
	$$equip("Quarrel", 0.0625, 2, Missile Weapon)
		opt
			begin mult Quantity "??1;1;x;x>0" noprint end
			end
	$$equip("Sling stone", 0.0625, 0, Missile Weapon)
		opt
			begin mult Quantity "??1;1;x;x>0" noprint end
			end

	end

sublist "Money and Valuables" memlist
	$$money("Copper $", 0.01, 0.1)
	$$item(Gemstone)
		textline editdlg 4
		textline format "%0ln (^o'Carats' carats)%-20rx|dp(0)|%-7rx|dew(@c@)|"
		textline sformat %0ln%-16r!$Var%-7r!0
		opt adj Carats "posscost+10.*x*x+40*x" "??1;1;;x>0; Carats must be greater than 0"
			exp Price 10.*`Carats`*`Carats`+40*`Carats`
			end
	$$money("Gold $", 0.01, 5)
	$$money("Jewelry", 0, 100)
	$$money("Ring", 0, 100)
	$$money("Silver $", 0.01, 1)
	$$money("$", 0, 1)
	end


sublist Poisons memlist
	$$equip("Caustic Tar", 0.2, 30)
		opt text Note "Causes intense pain, -1 DX for 1 hour" text Resist HT  end
	$$equip("Cobra Venom", 0.2, 100)
		opt text Dmg "3d/1d if HT roll made" text Resist HT text Note "Blood agent, multiple doses take full effect"  end
	$$equip("Wolfsbane", 0.2, 40)
		opt text Dmg "2d, numbness, spasms, DX -4 for 2 hours" text Resist HT  end
	end

sublist Shields memlist
	$$shield	Buckler	buckler,dx-4,shield-2	1	25	2	5/20	cr thr
	$$shield	Small Shield	shield,dx-4,buckler-2	2	40	8	5/30	cr thr
	$$shield	Medium Shield	shield,dx-4,buckler-2	3	60	15	7/40	cr thr
	$$shield	Large Shield	shield,dx-4,buckler-2	4	90	25	9/60	cr thr
	$$shield	Force Shield	shield,dx-4,ForceShield-2	4	1500	.5			11
	end

end



cat Quirks
	$$q	Quirk
		textline rand -1 dupexpected
	$$note(Note)
		textline rand -1

	sublist Clothing memlist
		$$q	Always wears \"lucky\" jacket
		$$q	Always wears [color]
		$$q	Always wears boots
		$$q	Always wears fedora
		$$q	Always wears funny hats
		$$q	Always wears thigh-high boots
		$$q	Always wears [item]
		$$q	Never wears [item]
		$$q	Wears men's clothing
		$$q	Clothing always mismatched
		$$q	Wears women's clothing
		$$q	Fashion impaired
		$$q	Wears glasses to look smart
		$$q	Wears outdated clothing
		end

	sublist "Physical Attraction" memlist
		$$q	Likes redheads
		$$q	Likes blonds
		$$q	Likes brunettes
		$$q	Attracted to thin people
		$$q	Attracted to hefty people
		end

	sublist Habits memlist
		$$q	Chews on unlit pipe
		$$q	Smokes Gauloise Bleu cigarettes
		$$q	Sleeps late
		$$q	Gets up early
		$$q	Sleeps naked
		$$q	Fitful sleeper
		$$q	Recurring dream/nightmare
		$$q	Vegetarian
		$$q	Only eats meat
		$$q	Sweet tooth
		$$q	Chocoholic
		$$q	Hates broccoli
		$$q	Has tea time every afternoon, regardless
		$$q	Doesn't drink alcohol
		$$q	Always eats kosher
		$$q	Only eats pizza
		$$q	Will not drink water
		$$q	Likes warm beer/ale
		$$q	Won't eat white foods (milk, potatoes)
		$$q	Always salts food
		$$q	Hates porridge
		$$q	Won't eat with left hand
		$$q	Always makes inscrutable comments
		$$q	Always carries a book
		$$q	Always carries an umbrella
		$$q	Constantly making origami figures
		$$q	Insults opponents
		$$q	Constantly clearing throat
		$$q	Maniacal laugh
		$$q	Evil grin
		$$q	Must always lead
		$$q	Shutterbug
		$$q	Gallant with the ladies
		$$q	Squints
		$$q	Showoff
		$$q	Always checks self in mirror
		$$q	Always scratches nose
		$$q	Scraches head when thinking
		$$q	Rolls eyes when annoyed
		$$q	Absently bounces leg while sitting.
		$$q	Always cracks knuckles
		$$q	Bites fingernails
		$$q	Always slaps people on the back
		$$q	Constantly taps fingers on table
		$$q	Plays with hair
		$$q	Chews gum
		$$q	Chews tobacco
		$$q	Snorts snuff

		end

	sublist "Hobbies" memlist
		$$q	Sports fanatic
		$$q	Collects coins
		$$q	Collects souvenirs from opponents
		$$q	Likes to climb
		$$q	Likes to fight
		$$q	Opera buff
		$$q	Chess player
		end

	sublist "Political Bent" memlist
		$$q	Dislikes authority
		$$q	Questions authority
		$$q	Respectful of authority
		$$q	Closet democrat
		$$q	Closet anarchist
		$$q	Closet fascist
		end
		
	sublist "Beliefs, Fears and Superstitions" memlist
		$$q	Afraid of rejection
		$$q	Afraid of drowning
		$$q	Afraid of heights
		$$q	Believes in astrology
		$$q	Believes in Fate
		$$q	Lucky number: 7
		$$q	Lucky number: 3
		$$q	Lucky number: 13
		$$q	Won't cross running water
		$$q	Obeys the Sabbath
		$$q	Won't eat pork
		$$q	Prays before every meal
		$$q	Tithes regularly
		$$q	Constantly quotes scripture
		$$q	Will not touch women
		$$q	Will not touch men
		end
		
	sublist "Personality" memlist
		$$q	Always last
		$$q	Always in a hurry
		$$q	Vain
		$$q	Energetic
		$$q	Impatient
		$$q	Manipulative
		$$q	Quiet
		$$q	Talkative
		$$q	Obnoxious
		$$q	Sarcastic
		$$q	Eternal Optimist
		$$q	Pessimist
		$$q	Practical Joker
		$$q	Vindictive
		end

	sublist "Speaking Mannerisms" memlist
		$$q	Irish brogue
		$$q	Foreign accent
		$$q	Speaks of self in third person
		$$q	Mutters under his breath
		$$q	Uses big words to impress listeners
		$$q	Speaks very softly
		$$q	Never uses contractions
		$$q	Constantly says \"you know\"
		$$q	Trails off in mid-sentence
		$$q	Argues incessantly
		$$q	Fond of Spoonerisms
		$$q	Never shuts up
		$$q	Always laughs at own jokes
		$$q	Stutters when excited
		$$q	Snipes at people behind their back
		$$q	Talks to inanimate objects
		$$q	Constantly interrupts others
		$$q	Speaks too loudly
		$$q	Always answers a question with a question
		$$q	Constantly complains
		$$q	Always talks about lost love
		$$q	Mumbles
		$$q	Swears frequently
		$$q	Mutters in Latin
		end
	end

cat Skills
	$$note(--)
		textline rand -1 dupexpected
	$$note(Note)
		textline rand -1
	$$sublist(Sublist)
		textline rand -1

	sublist "Animal" memlist
		$$skill("Animal Handling", MH, "Animal", "iq-6")
		$$skill("Falconry", MH, "Animal", "iq-5")
		$$skill("Packing", MH, "Animal", "animalhandling-6;iq-6#dx", "Sk:Animal Handling>=slc(12)")
		$$skill("Riding", PA, "Animal;*Riding", "animalhandling-3;dx-5")
		$$skill("Riding (Horse)", PA, "Animal;*Riding", "animalhandling-3;dx-5", , , , , , riding)
		$$skill("Teamster", MA, "Animal;Vehicle;*Teamster", "animalhandling-4;riding-2;cat:'Teamster'-3", "Sk:Animal Handling>=slc(12)")
		$$skill("Veterinary", MH, "Animal;Science", "animalhandling-5;cat:'Medical'-5", , tl)
		end
	sublist "Artistic" memlist
		$$skill("Artist", MH, "Artistic", "iq-6")
		$$skill("Bard", MA, "Artistic;Social;*Performance", "iq-5;performanceskill-2")
		$$skill("Calligraphy", PA, "Artistic;*Manual", "artist-2;dx-5", "Adv:Literacy|Configuration:TL>4-&tl")
		$$skill("Dancing", PA, "Artistic", "dx-5")
		sublist "Musical Instrument" memlist
			$$skill("Musical Instrument", MH, "Artistic;*Musical Instrument;*Musical", "cat:'Musical Instrument'-3")
			$$skill("Musical Instrument (Plucked)", MH, "Artistic;*Musical Instrument;*Plucked;*Musical", "cat:'Plucked'-3")
			$$skill("Musical Instrument (Bowed)", MH, "Artistic;*Musical Instrument;*Bowed;*Musical", "cat:'Bowed'-3")
			$$skill("Musical Instrument (Keyboard)", MH, "Artistic;*Musical Instrument;*Keyboard;*Musical", "cat:'Keyboard'-3")
			$$skill("Musical Instrument (Brass)", MH, "Artistic;*Musical Instrument;*Brass;*Musical", "cat:'Brass'-3")
			$$skill("Musical Instrument (Woodwind)", MH, "Artistic;*Musical Instrument;*Woodwind;*Musical", "cat:'Woodwind'-3")
			$$skill("Musical Instrument (Percussion)", MH, "Artistic;*Musical Instrument;*Percussion;*Musical", "cat:'Percussion'-3")
			$$skill("Musical Instrument (Electronic)", MH, "Artistic;*Musical Instrument;*Electronic;*Musical", "cat:'Electronic'-3")
			end
		$$skill("Photography", MA, "Artistic", "iq-5")
		$$skill("Poetry", MA, "Artistic", "iq-5;cat:'Language'-5")
		$$skill("Sculpting", PA, "Artistic", "dx-5;iq-5#iq")
		$$skill("Singing", PE/HT, "Artistic;*Musical", "HT-4")
		$$skill(Video Production, MA, "Artistic;Professional", "iq-6;cat:'Performance'-4", Configuration:TL>=7-&tl, tl/7+)
		$$skill("Writing", MA, "Artistic", "iq-5;cat:'Language'-5")
		end
	sublist "Athletic" memlist
		$$skill("Acrobatics", PH, "Athletic;*Melee;Sport", "dx-6")
		$$skill(Body Sense, PH, Athletic;Magical;Psionic, "dx-6;acrobatics-3")
		$$skill("Breath Control", MVH, "Athletic")
		$$see(Bicycling, %-5l!PE)
		$$skill(Flight, PA, Athletic;*Flight;*Magical;*Psionic, "dx-4;cat:'Flight'-2")
		$$skill("Free Fall", PA, "Athletic", "dx-5;ht-5#ht", , tl)
		$$see	Hiking	%-5l!PA
		$$skill("Jumping", PE, "Athletic;Sport")
		$$skill("Parachuting", PE, "Athletic", "dx-4;iq-6#iq")
		$$see(Riding, %-5l!PA)
		$$skill("Running", PH/HT, "Athletic;Sport", , , , "PH(~x,HT)+0*runningSpeed", , b_running+x/8, , "^n (Move: ^o'Move')")
			opt
				begin exp "Move" format('%n',runningSpeed) noprint end
				end
		$$skill("Scuba", MA, "Athletic", "iq-5;swimming-5")
		$$skill("Skiing", PH, "Athletic;Sport", "dx-6")
		sublist "Sports" memlist
			$$skill("Sports", PA, "Athletic;Sport;*Melee", "dx-5;skilldefST-5#skilldefST")
			$$skill("Sports (Baseball)", PA, "Athletic;Sport;*Ranged", "dx-5")
			$$skill("Sports (Basketball)", PA, "Athletic;Sport;*Ranged", "dx-5")
			$$skill("Sports (Bowling)", PA, "Athletic;Sport;*Ranged", "dx-5")
			$$skill("Sports (Cricket)", PA, "Athletic;Sport;*Ranged", "dx-5")
			$$skill("Sports (Football)", PA, "Athletic;Sport;*Ranged", "dx-5;skilldefST-5#skilldefST")
			$$skill("Sports (Generic Ball Sport)", PA, "Athletic;Sport;*Ranged", "dx-5;skilldefST-5#skilldefST")
			$$skill("Sports (Generic Non-Ball Sport)", PA, "Athletic;Sport;*Melee", "dx-5;skilldefST-5#skilldefST")
			$$skill("Sports (Golf)", PA, "Athletic;Sport;*Ranged", "dx-5")
			$$skill("Sports (Gymnastics)", PA, "Athletic;Sport;*Melee", "dx-5;skilldefST-5#skilldefST")
			$$skill("Sports (Handball)", PA, "Athletic;Sport;*Ranged", "dx-5")
			$$skill("Sports (Hockey)", PA, "Athletic;Sport;*Ranged", "dx-5")
			$$skill("Sports (Lacrosse)", PA, "Athletic;Sport;*Ranged", "dx-5")
			$$skill("Sports (Polo)", PA, "Athletic;Sport;*Ranged", "dx-5")
			$$skill("Sports (Soccer)", PA, "Athletic;Sport;*Ranged", "dx-5")
			$$skill("Sports (Racquetball)", PA, "Athletic;Sport;*Ranged", "dx-5")
			$$skill("Sports (Rugby)", PA, "Athletic;Sport;*Ranged", "dx-5;skilldefST-5#skilldefST")
			$$skill("Sports (Squash)", PA, "Athletic;Sport;*Ranged", "dx-5")
			$$skill("Sports (Table Tennis)", PA, "Athletic;Sport;*Ranged", "dx-5")
			$$skill("Sports (Tennis)", PA, "Athletic;Sport;*Ranged", "dx-5")
			$$skill("Sports (Volleyball)", PA, "Athletic;Sport;*Ranged", "dx-5")
			end
		$$skill("Swimming", PE, "Athletic;Sport", "skilldefST-5;dx-4#skilldefST")
		$$skill("Throwing", PH, "Athletic;Combat/Weapon;*Ranged")
		$$see(Weapon Skill, , Combat/Weapon)
		end
	sublist "Combat/Weapon" memlist
		$$skill("Axe Throwing", PE, "Combat/Weapon;Athletic;*Ranged;*Weapon", "dx-4")
		$$mcskill("Axe/Mace", PA, "Combat/Weapon;Athletic;*Melee;*Weapon;*One-Handed;*Long Weapon", "dx-5")
		$$skill("Battlesuit", PA, "Combat/Weapon;Athletic;Vehicle", "iq-5;dx-5;vaccsuit-3;exoskeleton-2#iq", Config:TL>=8-&tl, tl/8+)
		sublist "Beam Weapons" memlist
			$$skill("Beam Weapons", PE, "Combat/Weapon;Athletic;*Ranged;Beam Weapons", "dx-4;cat:'Beam Weapons'-4", Config:TL>=8-&tl, tl/8+, "gunsk(~x)")
			$$skill("Beam Weapons (Blaster)", PE, "Combat/Weapon;Athletic;*Ranged;Beam Weapons", "dx-4;cat:'Beam Weapons'-4", Config:TL>=9-&tl, tl/9+, "gunsk(~x)")
			$$skill("Beam Weapons (Disruptor)", PE, "Combat/Weapon;Athletic;*Ranged;Beam Weapons", "dx-4;cat:'Beam Weapons'-4", Config:TL>=9-&tl, tl/9+, "gunsk(~x)")
			$$skill("Beam Weapons (Disintegrator)", PE, "Combat/Weapon;Athletic;*Ranged;Beam Weapons", "dx-4;cat:'Beam Weapons'-4", Config:TL>=8-&tl, tl/8+, "gunsk(~x)")
			$$skill("Beam Weapons (Electrolaser)", PE, "Combat/Weapon;Athletic;*Ranged;Beam Weapons", "dx-4;cat:'Beam Weapons'-4", Config:TL>=8-&tl, tl/8+, "gunsk(~x)")
			$$skill("Beam Weapons (Flamer)", PE, "Combat/Weapon;Athletic;*Ranged;Beam Weapons", "dx-4;cat:'Beam Weapons'-4", Config:TL>=8-&tl, tl/8+, "gunsk(~x)")
			$$skill("Beam Weapons (Force Beams)", PE, "Combat/Weapon;Athletic;*Ranged;Beam Weapons", "dx-4;cat:'Beam Weapons'-4", Config:TL>=8-&tl, tl/8+, "gunsk(~x)")
			$$skill("Beam Weapons (Laser)", PE, "Combat/Weapon;Athletic;*Ranged;Beam Weapons", "dx-4;cat:'Beam Weapons'-4", Config:TL>=8-&tl, tl/8+, "gunsk(~x)")
			$$skill("Beam Weapons (Neural)", PE, "Combat/Weapon;Athletic;*Ranged;Beam Weapons", "dx-4;cat:'Beam Weapons'-4", Config:TL>=8-&tl, tl/8+, "gunsk(~x)")
			$$skill("Beam Weapons (Tachyonic)", PE, "Combat/Weapon;Athletic;*Ranged;Beam Weapons", "dx-4;cat:'Beam Weapons'-4", Config:TL>=11-&tl, tl/11+, "gunsk(~x)")
			$$skill("Beam Weapons (Sonic)", PE, "Combat/Weapon;Athletic;*Ranged;Beam Weapons", "dx-4;cat:'Beam Weapons'-4", Config:TL>=8-&tl, tl/8+, "gunsk(~x)")
			end
		sublist "Black Powder Weapons" memlist
			# This list does not include every possible combination of lock-type and weapon-type, 
			# only those actually used by weapons listed in GURPS High-Tech.
			# The variable names used are the abbreviations used in the GURPS High-Tech weapon tables
			# (minus spaces and parentheses).
			$$skill("Black Powder Weapons", PE, "Combat/Weapon;Athletic;*Black Powder Weapons;*Ranged", "dx-4;cat:'Black Powder Weapons'-4", Config:TL>=3-&tl, tl/3+, "gunsk(~x)")
			$$skill("Black Powder Weapons (Grenade)", PE, "Combat/Weapon;Athletic;*Black Powder Weapons;*Ranged", "dx-4", Config:TL>=4-&tl, tl/4+, "gunsk(~x)")

			$$skill("Black Powder Weapons (Handgonne)", PE, "Combat/Weapon;Athletic;*Black Powder Weapons;*Ranged",
				"dx-6;cat:'Black Powder Weapons'-7", Config:TL>=3-&tl, tl/3+, "gunsk(~x)", , , BPWHnG)

			$$skill("Black Powder Weapons (Matchlock Hand Mortar)", PE, "Combat/Weapon;Athletic;*Black Powder Weapons;*Ranged", 
				"dx-4;BPWFLHnMortar-3", Config:TL>=4-&tl, tl/4+, "gunsk(~x)", , , BPWMLHnMortar)
			$$skill("Black Powder Weapons (Matchlock Rifle)", PE, "Combat/Weapon;Athletic;*Rifle;*Black Powder Weapons;*Ranged", 
				"dx-4;BPWMLMsk-2;BPWFLMsk-5;BPWWLRfl-3;BPWFLRfl-3;BPWCLRfl-5;BPWFLShg-5;BPWMLPtl-4;BPWWLPtl-7;BPWFLPtl-7;BPWCLPtl-9", Config:TL>=4-&tl, tl/4+, "gunsk(~x)", , , BPWMLRfl)
			$$skill("Black Powder Weapons (Matchlock Musket)", PE, "Combat/Weapon;Athletic;*Rifle;*Black Powder Weapons;*Ranged",
				"dx-4;BPWFLMsk-3;BPWMLRfl-2;BPWWLRfl-5;BPWFLRfl-5;BPWCLRfl-7;BPWFLShg-4;BPWMLPtl-4;BPWWLPtl-7;BPWFLPtl-7;BPWCLPtl-9", Config:TL>=4-&tl, tl/4+, "gunsk(~x)", , , BPWMLMsk)
			$$skill("Black Powder Weapons (Matchlock Pistol)", PE, "Combat/Weapon;Athletic;*Black Powder Weapons;*Ranged", 
				"dx-4;BPWWLPtl-3;BPWFLPtl-3;BPWCLPtl-5", Config:TL>=4-&tl, tl/4+, "gunsk(~x)", , , BPWMLPtl)
			$$skill("Black Powder Weapons (Matchlock Shotgun)", PE, "Combat/Weapon;Athletic;*Rifle;*Black Powder Weapons;*Ranged",
				"dx-4;BPWMLMsk-1;BPWFLShg-2;BPWWLShg-2;BPWMLRfl-2;BPWWLRfl-5;BPWFLRfl-5;BPWCLRfl-7;BPWMLPtl-4;BPWWLPtl-7;BPWFLPtl-7;BPWCLPtl-9", Config:TL>=4-&tl, tl/4+, "gunsk(~x)", , , BPWMLShg)

			$$skill("Black Powder Weapons (Wheellock Musket)", PE, "Combat/Weapon;Athletic;*Rifle;*Black Powder Weapons;*Ranged", 
				"dx-4;BPWMLMsk-2;BPWFLMsk-1;BPWCLMsk-2;BPWMLRfl-4;BPWWLRfl-2;BPWFLRfl-3;BPWCLRfl-4;BPWMLShg-3;BPWWLShg-1;BPWFLShg-2;BPWMLPtl-6;BPWWLPtl-4;BPWFLPtl-4;BPWCLPtl-6",
				Config:TL>=4-&tl, tl/4+, "gunsk(~x)", , , BPWWLMsk)
			$$skill("Black Powder Weapons (Wheellock Shotgun)", PE, "Combat/Weapon;Athletic;*Rifle;*Black Powder Weapons;*Ranged", 
				"dx-4;BPWMLMsk-3;BPWFLMsk-2;BPWCLMsk-3;BPWMLRfl-5;BPWWLRfl-2;BPWFLRfl-3;BPWCLRfl-5;BPWMLShg-2;BPWWLMsk-1;BPWFLShg-1;BPWMLPtl-6;BPWWLPtl-4;BPWFLPtl-4;BPWCLPtl-6",
				Config:TL>=4-&tl, tl/4+, "gunsk(~x)", , , BPWWLShg)
			$$skill("Black Powder Weapons (Wheellock Pistol)", PE, "Combat/Weapon;Athletic;*Black Powder Weapons;*Ranged",
				"dx-4;BPWMLPtl-2;BPWFLPtl-1;BPWCLPtl-2", Config:TL>=4-&tl, tl/4+, "gunsk(~x)", , , BPWWLPtl)
			$$skill("Black Powder Weapons (Wheellock Rifle)", PE, "Combat/Weapon;Athletic;*Rifle;*Black Powder Weapons;*Ranged", 
				"dx-4;BPWMLMsk-4;BPWFLMsk-2;BPWMLRfl-2;BPWFLRfl-1;BPWCLRfl-2;BPWFLShg-2;BPWMLPtl-6;BPWWLPtl-4;BPWFLPtl-4;BPWCLPtl-6", Config:TL>=4-&tl, tl/4+, "gunsk(~x)", , , BPWWLRfl)
			$$skill("Black Powder Weapons (Wheellock Hand Mortar)", PE, "Combat/Weapon;Athletic;*Black Powder Weapons;*Ranged", 
				"dx-4;BPWMLHnMortar-2;BPWFLHnMortar-1", Config:TL>=4-&tl, tl/4+, "gunsk(~x)", , , BPWWLHnMortar)

			$$skill("Black Powder Weapons (Flintlock Musket)", PE, "Combat/Weapon;Athletic;*Rifle;*Black Powder Weapons;*Ranged", 
				"dx-4;BPWMLMsk-2;BPWMLRfl-4;BPWWLRfl-2;BPWFLRfl-2;BPWCLRfl-4;BPWFLShg-2;BPWMLPtl-6;BPWWLPtl-4;BPWFLPtl-4;BPWCLPtl-6", Config:TL>=4-&tl, tl/4+, "gunsk(~x)", , , BPWFLMsk)
			$$skill("Black Powder Weapons (Flintlock Rifle)", PE, "Combat/Weapon;Athletic;*Rifle;*Black Powder Weapons;*Ranged", 
				"dx-4;BPWMLMsk-4;BPWFLMsk-2;BPWMLRfl-2;BPWWLRfl-1;BPWCLRfl-2;BPWFLShg-2;BPWMLPtl-6;BPWWLPtl-4;BPWFLPtl-4;BPWCLPtl-6", Config:TL>=4-&tl, tl/4+, "gunsk(~x)", , , BPWFLRfl)
			$$skill("Black Powder Weapons (Flintlock Shotgun)", PE, "Combat/Weapon;Athletic;*Black Powder Weapons;*Ranged", 
				"dx-4;BPWMLMsk-3;BPWFLMsk-1;BPWMLRfl-4;BPWWLRfl-2;BPWFLRfl-2;BPWCLRfl-4;BPWMLPtl-6;BPWWLPtl-4;BPWFLPtl-4;BPWCLPtl-6", Config:TL>=4-&tl, tl/4+, "gunsk(~x)", , , BPWFLShg)
			$$skill("Black Powder Weapons (Flintlock Pistol)", PE, "Combat/Weapon;Athletic;*Black Powder Weapons;*Ranged", 
				"dx-4;BPWWLPtl-1;BPWMLPtl-2;BPWCLPtl-2", Config:TL>=4-&tl, tl/4+, "gunsk(~x)", , , BPWFLPtl)
			$$skill("Black Powder Weapons (Flintlock Hand Mortar)", PE, "Combat/Weapon;Athletic;*Black Powder Weapons;*Ranged", 
				"dx-4;BPWWLHnMortar-1;BPWMLHnMortar-2", Config:TL>=4-&tl, tl/4+, "gunsk(~x)", , , BPWFLHnMortar)

			$$skill("Black Powder Weapons (Hand Mortar)", PE, "Combat/Weapon;Athletic;*Black Powder Weapons;*Ranged", 
				"dx-4", Config:TL>=4-&tl, tl/4+, "gunsk(~x)", , , BPWHnMortar)
			$$skill("Black Powder Weapons (Special Weapon)", PE, "Combat/Weapon;Athletic;*Black Powder Weapons;*Ranged", 
				"dx-4", Config:TL>=4-&tl, tl/4+, "gunsk(~x)", , , BPWSpWpn)

			$$skill("Black Powder Weapons (Caplock Pistol)", PE, "Combat/Weapon;Athletic;*Black Powder Weapons;*Ranged", 
				"dx-4;BPWWLPtl-1;BPWFLPtl-1;BPWMLPtl-3", Config:TL>=5-&tl, tl/5+, "gunsk(~x)", , , BPWCLPtl)
			$$skill("Black Powder Weapons (Caplock Rifle)", PE, "Combat/Weapon;Athletic;*Rifle;*Black Powder Weapons;*Ranged", 
				"dx-4;BPWMLMsk-5;BPWFLMsk-3;BPWMLRfl-3;BPWWLRfl-1;BPWFLRfl-1;BPWFLShg-3;BPWMLPtl-7;BPWWLPtl-5;BPWFLPtl-5;BPWCLPtl-4",
				Config:TL>=5-&tl, tl/5+, "gunsk(~x)", , , BPWCLRfl)
			$$skill("Black Powder Weapons (Caplock Musket)", PE, "Combat/Weapon;Athletic;*Rifle;*Black Powder Weapons;*Ranged", 
				"dx-4;BPWMLMsk-3;BPWFLMsk-2;BPWFLMsk-2;BPWMLRfl-5;BPWWLRfl-3;BPWFLRfl-3;BPWFLShg-2;BPWMLPtl-7;BPWWLPtl-5;BPWFLPtl-5;BPWCLPtl-4",
				Config:TL>=5-&tl, tl/5+, "gunsk(~x)", , , BPWCLMsk)
			$$skill("Black Powder Weapons (Caplock Shotgun)", PE, "Combat/Weapon;Athletic;*Rifle;*Black Powder Weapons;*Ranged", 
				"dx-4;BPWMLMsk-4;BPWFLMsk-3;BPWFLMsk-3;BPWMLRfl-5;BPWWLRfl-3;BPWFLRfl-3;BPWFLShg-1;BPWWLShg-1;BPWMLShg-3;BPWMLPtl-7;BPWWLPtl-5;BPWFLPtl-5;BPWCLPtl-4",
				Config:TL>=5-&tl, tl/5+, "gunsk(~x)", , , BPWCLShg)
			end
		$$skill("Blackjack", PE, "Combat/Weapon;Athletic;*Melee;*Weapon;*One-Handed;*Close", "dx-4")
		$$skill("Blowpipe", PH, "Combat/Weapon;Athletic;*Ranged;*Weapon", "dx-6")
		$$skill("Bolas", PA, "Combat/Weapon;Athletic;*Ranged;*Weapon")
		$$skill("Bow", PH, "Combat/Weapon;Athletic;*Ranged;*Weapon", "dx-6")
		$$mcskill("Boxing", PA, "Combat/Weapon;Athletic;*Melee;*Hand-to-Hand", , , , , , , , , "(c?2/3:.5)+b_bhparry+combatreflexes")
		$$mcskill("Brawling", PE, "Combat/Weapon;Athletic;*Melee;*Hand-to-Hand", , , , , , , , , "(c?2/3:.5)+b_bhparry+combatreflexes")
		$$mcskill("Broadsword", PA, "Combat/Weapon;Athletic;*Melee;*Weapon;*One-Handed;*Long Weapon;*Sword", "dx-5;shortsword-2;forcesword-3;broadswordart-3")
		$$bcskill("Buckler", PE, "Combat/Weapon;Athletic;*Melee", "dx-4;shield-2")
		$$bcskill("Cloak", PA, "Combat/Weapon;Athletic;*Melee", "dx-5;buckler-4;shield-4")
		$$skill("Crossbow", PE, "Combat/Weapon;Athletic;*Ranged;*Weapon", "dx-4")
		$$skill("Fast-Draw", PE, "Combat/Weapon;Athletic")
		##mcskill("Fencing", PA, "Combat/Weapon;Athletic;*Melee;*Weapon;*One-Handed;*Long Weapon", "dx-5;FencingArt-3;FencingSport-3", , , , , , , , "(c?2/3:.5)+wpbonus(0)")
		$$mcskill("Fencing", PA, "Combat/Weapon;Athletic;*Melee;*Weapon;*One-Handed;*Long Weapon;*Fencing;*Sword",
			"dx-5;cat:'Fencing'-3", , , , , , , , "(c?2/3:.5)+wpbonus(0)")

		$$mcskill("Flail", PH, "Combat/Weapon;Athletic;*Melee;*Weapon;*One-Handed;*Long Weapon", "dx-6")
		$$skill("Force Shield", PE, "Combat/Weapon;Athletic;*Melee", "dx-4;shield-2", Config:TL>=11-&tl, tl/11+)
		$$mcskill("Force Sword", PA, "Combat/Weapon;Athletic;*Melee;*Weapon;*One-Handed;*Long Weapon;*Sword", "dx-5;broadsword-3;shortsword-3;twohandedsword-3", Config:TL>=11-&tl, tl/11+)
		
		sublist "Gunner" memlist
			# Variable names are the abbreviations used in GURPS High-Tech (minus parentheses)
			$$skill("Gunner", PA, "Combat/Weapon;Athletic;Gunner;Vehicle;*Ranged", "dx-5;cat:'Gunner'-4", , tl, "pa(~x,dx+(iq>9)+(iq>11))", , , Gnr)
			$$skill("Gunner (Machine Gun)", PA, "Combat/Weapon;Athletic;Gunner;Vehicle;*Ranged", "dx-5;cat:'Gunner'-4", Config:TL>=6-&tl, tl/6+, "pa(~x,dx+(iq>9)+(iq>11))", , , GnrMG)
			$$skill("Gunner (Mechanical Machine Gun)", PA, "Combat/Weapon;Athletic;Gunner;Vehicle;*Ranged", "dx-5;cat:'Gunner'-4", Config:TL>=5-&tl, tl/5+, "pa(~x,dx+(iq>9)+(iq>11))", , , GnrMcMG)
			$$skill("Gunner (Mortar)", PA, "Combat/Weapon;Athletic;Gunner;Vehicle;*Ranged", "dx-5;cat:'Gunner'-4", Config:TL>=6-&tl, tl/6+, "pa(~x,dx+(iq>9)+(iq>11))", , , GnrMortar)
			$$skill("Gunner (ATGM)", PA, "Combat/Weapon;Athletic;Gunner;Vehicle;*Ranged", "dx-5;cat:'Gunner'-4", Config:TL>=7-&tl, tl/7+, "pa(~x,dx+(iq>9)+(iq>11))", , , GnrATGM)
			$$skill("Gunner (Cannon)", PA, "Combat/Weapon;Athletic;Gunner;Vehicle;*Ranged", "dx-5;cat:'Gunner'-4", Config:TL>=5-&tl, tl/5+, "pa(~x,dx+(iq>9)+(iq>11))", , , GnrCannon)
			$$skill("Gunner (Missile)", PA, "Combat/Weapon;Athletic;Gunner;Vehicle;*Ranged", "dx-5;cat:'Gunner'-4", Config:TL>=7-&tl, tl/7+, "pa(~x,dx+(iq>9)+(iq>11))", , , GnrMissile)
			$$skill("Gunner (Blaster)", PA, "Combat/Weapon;Athletic;Gunner;Vehicle;*Ranged", "dx-5;cat:'Gunner'-4", Config:TL>=9-&tl, tl/9+, "pa(~x,dx+(iq>9)+(iq>11))", , , GnrBlaster)
			$$skill("Gunner (Railgun)", PA, "Combat/Weapon;Athletic;Gunner;Vehicle;*Ranged", "dx-5;cat:'Gunner'-4", Config:TL>=8-&tl, tl/8+, "pa(~x,dx+(iq>9)+(iq>11))", , , GnrRailgun)
			$$skill("Gunner (SAM)", PA, "Combat/Weapon;Athletic;Gunner;*Ranged", "dx-5;cat:'Gunner'-4", Config:TL>=7-&tl, tl/7+, "pa(~x,dx+(iq>9)+(iq>11))", , , GnrSAM)
			$$skill("Gunner (Beam Weapons)", PA, "Combat/Weapon;Athletic;Gunner;Vehicle;*Ranged", "dx-5;cat:'Gunner'-4", Config:TL>=8-&tl, tl/8+, "pa(~x,dx+(iq>9)+(iq>11))", , , GnrBeamWeapons)
			end
		sublist "Guns" memlist
			# Variable names are the abbreviations used in GURPS High-Tech
			# (minus spaces and parentheses)
			$$skill("Guns", PE, "Combat/Weapon;Athletic;Guns;*Ranged", "dx-4;cat:'Guns'-4", Config:TL>=6-&tl, tl/6+, "gunsk(~x)")
			$$skill("Guns (Rifle)", PE, "Combat/Weapon;Athletic;Guns;*Ranged",
				"dx-4;GunsShg-2;GunsPtl-4;GunsLtAu-4;GunsMPtl-5;GunsLAW-3;GunsGrnLa-3", Config:TL>=5-&tl, tl/5+, "gunsk(~x)", , , GunsRfl)
			$$skill("Guns (Shotgun)", PE, "Combat/Weapon;Athletic;Guns;*Ranged", 
				"dx-4;GunsRfl-2;GunsPtl-4;GunsLtAu-4;GunsMptl-5;GunsLAW-3;GunsGrnLa-3", Config:TL>=5-&tl, tl/5+, "gunsk(~x)", , , GunsShg)
			$$skill("Guns (Light Automatic)", PE, "Combat/Weapon;Athletic;Guns;*Ranged", 
				"dx-4;GunsRfl-4;GunsShg-4;GunsMPtl-5;GunsLAW-5;GunsGrnLa-5;GunsPtl-5", Config:TL>=5-&tl, tl/5+, "gunsk(~x)", , , GunsLtAu)
			$$skill("Guns (Pistol)", PE, "Combat/Weapon;Athletic;Guns;*Ranged", 
				"dx-4;GunsMPtl-4;GunsLtAu-5;GunsRfl-4;GunsShg-4;GunsLAW-5;GunsGrnLa-5", Config:TL>=5-&tl, tl/5+, "gunsk(~x)", , , GunsPtl)
			$$skill("Guns (Machine Pistol)", PE, "Combat/Weapon;Athletic;Guns;*Ranged", 
				"dx-4;GunsPtl-4;GunsRfl-5;GunsShg-5;GunsLtAu-5", Config:TL>=5-&tl, tl/5+, "gunsk(~x)", , , GunsMPtl)
			$$skill("Guns (Grenade Launcher)", PE, "Combat/Weapon;Athletic;Guns;*Ranged", 
				"dx-4;GunsRfl-3;GunsShg-3;GunsLtAu-5", Config:TL>=5-&tl, tl/5+, "gunsk(~x)", , , GunsGrnLa)
			$$skill("Guns (Light Antitank Weapon)", PE, "Combat/Weapon;Athletic;Guns;*Ranged", 
				"dx-4;GunsRfl-3;GunsShg-3;GunsLtAu-5;GunsGyroc-3;GunsMissile-3;cat:'Guns'-4", Config:TL>=5-&tl, tl/5+, "gunsk(~x)", , , GunsLAW)
			$$skill("Guns (Flamethrower)", PE, "Combat/Weapon;Athletic;Guns;*Ranged", 
				"dx-4", Config:TL>=5-&tl, tl/5+, "gunsk(~x)", , , GunsFlmTh)
			$$skill("Guns (Special Weapon)", PE, "Combat/Weapon;Athletic;Guns;*Ranged", 
				"dx-4", Config:TL>=5-&tl, tl/5+, "gunsk(~x)", , , GunsSpWpn)
			$$skill("Guns (Gyroc)", PE, "Combat/Weapon;Athletic;Guns;*Ranged", "dx-4;cat:'Guns'-4;GunsLaw-3;GunsMissile-3", Config:TL>=7-&tl, tl/7+, "gunsk(~x)")
			$$skill("Guns (Missile)", PE, "Combat/Weapon;Athletic;Guns;*Ranged", "dx-4;cat:'Guns'-4;GunsGyroc-3;GunsLAW-3", Config:TL>=7-&tl, tl/7+, "gunsk(~x)")
			$$skill("Guns (Needler)", PE, "Combat/Weapon;Athletic;Guns;*Ranged", "dx-4;cat:'Guns'-4", Config:TL>=8-&tl, tl/8+, "gunsk(~x)")
			$$skill("Guns (Tangler)", PE, "Combat/Weapon;Athletic;Guns;*Ranged", "dx-4;cat:'Guns'-4", Config:TL>=8-&tl, tl/8+, "gunsk(~x)")
			end
		$$mcskill("Judo", PH, "Combat/Weapon;Athletic;*Melee;*Hand-to-Hand", JudoArt-3;JudoSport-3, , , , , , , , "(c?2/3:.5)+b_bhparry+combatreflexes")
		$$mcskill("Karate", PH, "Combat/Weapon;Athletic;*Melee;*Hand-to-Hand", KarateArt-3;KarateSport-3, , , , , , , , "(c?2/3:.5)+b_bhparry+combatreflexes")
		$$mcskill("Knife", PE, "Combat/Weapon;Athletic;*Melee;*Weapon;*One-Handed;*Close", "dx-4", , , , , , , , ".5-1+wpbonus(0)")
		$$skill("Knife Throwing", PE, "Combat/Weapon;Athletic;*Ranged;*Weapon", "dx-4")
		$$mcskill("Lance", PA, "Combat/Weapon;Athletic;*Melee;*Weapon;*One-Handed;*Long Weapon", "dx-6;spear-(riding>=slc(12)?3:20)", "#1,Sk:Riding>=slc(12)")
		$$mcskill("Lasso (Riata)", PA, "Combat/Weapon;Athletic;*Ranged;*Weapon")
		$$mcskill("Net", PH, "Combat/Weapon;Athletic;*Melee;*Weapon")
		
		$$mcskill("Polearm", PA, "Combat/Weapon;Athletic;*Melee;*Weapon;*Long Weapon", "dx-5")
		$$bcskill("Shield", PE, "Combat/Weapon;Athletic;*Melee", "dx-4;buckler-2")
		$$mcskill("Shortsword", PA, "Combat/Weapon;Athletic;*Melee;*Weapon;*One-Handed;*Long Weapon;*Sword", "dx-5;broadsword-2;forcesword-3;shortswordart-3")
		$$skill("Sling", PH, "Combat/Weapon;Athletic;*Ranged;*Weapon", "dx-6")
		$$mcskill("Spear", PA, "Combat/Weapon;Athletic;*Melee;*Weapon;*One-Handed;*Long Weapon", "dx-5;staff-2")
		$$skill("Spear Thrower", PA, "Combat/Weapon;Athletic;*Ranged;*Weapon", "dx-4;spearthrowing-4")
		$$skill("Spear Throwing", PE, "Combat/Weapon;Athletic;*Ranged;*Weapon", "dx-4;spearthrower-4")
		$$skill("Speed-Load", PE, "Combat/Weapon;Athletic", , Config:TL>=5-&tl, tl/5+)
		$$mcskill("Staff", PH, "Combat/Weapon;Athletic;*Melee;*Weapon;*Long Weapon", "dx-5;spear-2", , , , , , , , "(c?2/3:.5)+wpbonus(0)")
		$$skill(Throwing Stick, PE, "Combat/Weapon;Athletic;*Ranged;*Weapon", "dx-4")
		$$skill("Thrown Weapon", PE, "Combat/Weapon;Athletic;*Ranged;*Weapon", "dx-4")
		$$mcskill("Two-Handed Axe/Mace", PA, "Combat/Weapon;Athletic;*Melee;*Weapon;*Long Weapon", "dx-5")
		$$mcskill("Two-Handed Sword", PA, "Combat/Weapon;Athletic;*Melee;*Weapon;*Long Weapon;*Sword", "dx-5;forcesword-3")
		$$mcskill("Whip", PA, "Combat/Weapon;Athletic;*Melee;*Weapon;*One-Handed;*Long Weapon")
		$$skill(Wrestling, PA, "Combat/Weapon;Athletic;*Melee;*Hand-to-Hand", "dx-5;WrestlingSport-3")
		end
	sublist "Craft" memlist
		sublist Armoury memlist
			$$skill("Armoury", MA, "Craft;*Armoury", "iq-5;blacksmith-3", , tl)
				opt
					begin text Specialty "" noprint end
					end
			$$skill	Armoury (Rifles and Handguns)	MA	Craft;*Armoury	iq-5;cat:'Guns'-6		tl/5+
			$$skill	Armoury (Beam Handguns)	MA	Craft;*Armoury	iq-5;beamweapons-6		tl/8+
			$$skill	Armoury (Vehicular Weaponry)	MA	Craft;*Armoury	iq-5;beamweapons-6		tl
			$$skill	Armoury (Spaceship Weaponry)	MA	Craft;*Armoury	iq-5;beamweapons-6		tl/8+
			$$skill	Armoury (Artillery)	MA	Craft;*Armoury	iq-5		tl
			$$skill	Armoury (Body Armor)	MA	Craft;*Armoury	iq-5		tl
			$$skill	Armoury (Hand Weapons)	MA	Craft;*Armoury	iq-5		tl
			$$skill	Armoury (Needle Handguns)	MA	Craft;*Armoury	iq-5;gunsneedler-6		tl/8+
			$$skill	Armoury (Airplane Weaponry)	MA	Craft;*Armoury	iq-5		tl/6+
			$$skill	Armoury (Psi Weaponry)	MA	Craft;*Armoury	iq-5		tl/8+
			$$skill	Armoury (Spaceship Armor)	MA	Craft;*Armoury	iq-5		tl/8+
			$$skill	Armoury (Other Modern Specialties)	MA	Craft;*Armoury	iq-5		tl/7+
			end
		# FIX: the following doesn't quite work if you have a zero-cost default level.
		$$skill("Blacksmith", MA, "Craft", "iq-5-(ST<13?13-ST:0);jeweler-4-(ST<13?13-ST:0)", , tl, "MMA(~x+(ST<13?13-ST:0),iq)")
			opt
				exp "Note" "st<13?format('Includes -%d penalty for %d ST',13-ST,st):'-1 penalty for each point of ST below 13.'"
				end
		$$skill("Carpentry", ME, "Craft", "iq-4;dx-4#dx")
		$$skill("Cooking", ME, "Craft", "iq-4")
		$$skill("Jeweler", MH, "Craft", "iq-6;blacksmith-4", , tl)
		$$skill("Leatherworking", ME, "Craft", "iq-4;dx-5#dx")
		sublist Mechanics memlist
			$$skill("Mechanic", MA, "Craft;Vehicle;*Mechanic", "iq-5;engineer-4", , tl/1+)
			$$skill("Mechanic (Simple Machines)", MA, "Craft;Vehicle;*Mechanic", "iq-5;engineersimplemachines-4", Conf:TL>=2, tl/2+)
			$$skill("Mechanic (Vehicle)", MA, "Craft;Vehicle;*Mechanic", "iq-5;engineervehicle-4", Conf:TL>=1, tl/1+)
			$$skill("Mechanic (Clockwork)", MA, "Craft;Vehicle;*Mechanic", "iq-5;engineerclockwork-4", Conf:TL>=3, tl/3+)
			$$skill("Mechanic (Gasoline Engine)", MA, "Craft;Vehicle;*Mechanic", "iq-5;engineervehicle-4", Conf:TL>=6, tl/6+)
			$$skill("Mechanic (Aircraft)", MA, "Craft;Vehicle;*Mechanic", "iq-5;engineeraircraft-4", Conf:TL>=6, tl/6+)
			$$skill("Mechanic (Fuel Cell)", MA, "Craft;Vehicle;*Mechanic", "iq-5;engineer-4", Conf:TL>=7, tl/7+)
			$$skill("Mechanic (Electric Motor)", MA, "Craft;Vehicle;*Mechanic", "iq-5;engineer-4", Conf:TL>=6, tl/6+)
			$$skill("Mechanic (Spacecraft)", MA, "Craft;Vehicle;*Mechanic", "iq-5;engineerspacecraft-4", Conf:TL>=7, tl/7+)
			$$skill("Mechanic (Robotics)", MA, "Craft;Vehicle;*Mechanic", "iq-5;engineerrobotics-4", Conf:TL>=7, tl/7+)
			$$skill("Mechanic (Steam Engine)", MA, "Craft;Vehicle;*Mechanic", "iq-5;engineer-4", Conf:TL>=5, tl/5+)
			$$skill("Mechanic (Marine Vessel)", MA, "Craft;Vehicle;*Mechanic", "iq-5;engineermarinevessel-4", Conf:TL>=5, tl/5+)
			end
		$$skill("Pottery", MA, "Craft", "iq-5")
		$$skill("Shipbuilding", MH, "Craft", "iq-6", , tl)
		$$skill("Woodworking", PA, "Craft", "dx-5;carpentry-3")
		end
	sublist "Generic" 
			textline rand -1
		memlist
		$$skill("MA Skill", MA, "Generic", "`Default`")
			textline rand -1 uniquevar
			opt begin text Default "" noprint keepold end end
		$$skill("ME Skill", ME, "Generic", "`Default`")
			textline rand -1 uniquevar
			opt begin text Default "" noprint keepold end end
		$$skill("MH Skill", MH, "Generic", "`Default`")
			textline rand -1 uniquevar
			opt begin text Default "" noprint keepold end end
		$$skill("MVH Skill", MVH, "Generic", "`Default`")
			textline rand -1 uniquevar
			opt begin text Default "" noprint keepold end end
		$$skill("PA Skill", PA, "Generic", "`Default`")
			textline rand -1 uniquevar
			opt begin text Default "" noprint keepold end end
		$$skill("PE Skill", PE, "Generic", "`Default`")
			textline rand -1 uniquevar
			opt begin text Default "" noprint keepold end end
		$$skill("PH Skill", PH, "Generic", "`Default`")
			textline rand -1 uniquevar
			opt begin text Default "" noprint keepold end end
		end
	sublist Hobby memlist
		$$skill	Games	ME	Hobby	iq-5
		$$genericSkill	Hobby Skill	0.5	Hobby	IQ-5
		end
	sublist "Language" memlist
		$$sublist(Languages)
			textline rand -1
		sublist "Fantasy Languages" memlist
			$$flang("Anglish")
			$$flang(Aralaise)
			$$flang(Balish)
			$$flang(Common Tongue)
			$$flang("Dwarvish")
			$$flang("Elvish", MH)
			$$flang("Gnomish")
			$$flang(Ghoulish)
			$$flang(Goblin)
			$$flang("Ogrish")
			$$flang("Orcish", ME)
			$$flang("Sahudese")
			$$flang("Unnamed Tongue", MH)
			$$flang(Winged Folk)
			end
		$$skill("Gesture", ME, "Language", "iq-4;signlanguage")
		$$lang("Language (MA)")
			textline rand -1
		$$lang("Language (ME)", ME)
			textline rand -1
		$$lang("Language (MH)", MH)
			textline rand -1
		$$lang("Language (MVH)", MVH)
			textline rand -1
		$$lang("Sign Language")
		$$lang("Telegraphy", ME)
		sublist "Archaic Languages" memlist
			$$alang(Anglo-Saxon)
			$$alang("Ancient Egyptian", MH)
			$$alang("Ancient Greek")
			$$alang("Ancient Mayan", MH)
			$$alang("Ancient Persian", MH)
			$$alang("Latin")
			$$alang("Old English")
			$$alang(Old Norse)
			$$alang(Frankish)
			$$alang("Sanskrit", MH)
			end
		sublist "World Languages" memlist
			$$wlang("Afrikaans")
			$$wlang("Albanian")
			$$wlang("Apache")
			$$wlang("Arabic")
			$$wlang("Bantu")
			$$wlang("Basque", MH)
			$$wlang("Bulgarian")
			$$wlang("Chinese (Cantonese)")
			$$wlang("Chinese (Mandarin)")
			$$wlang("Coptic")
			$$wlang("Czech")
			$$wlang("Danish")
			$$wlang("Dutch")
			$$wlang("English")
			$$wlang("Estonian")
			$$wlang("Faroese")
			$$wlang("Farsi (Persian)")
			$$wlang("Finnish")
			$$wlang("French")
			$$wlang("Gaelic")
			$$wlang("German")
			$$wlang("Greek")
			$$wlang("Hebrew")
			$$wlang("Hindi")
			$$wlang("Hmong")
			$$wlang("Hungarian")
			$$wlang("Icelandic")
			$$wlang("Indonesian")
			$$wlang("Inuit")
			$$wlang("Irish")
			$$wlang("Italian")
			$$wlang("Japanese")
			$$wlang("Kazakh")
			$$wlang("Korean")
			$$wlang("Lakota")
			$$wlang("Latvian")
			$$wlang("Lithuanian")
			$$wlang("Malay")
			$$wlang("Navajo", MH)
			$$wlang("Norwegian")
			$$wlang("Polish")
			$$wlang("Portuguese")
			$$wlang("Romanian")
			$$wlang("Russian")
			$$wlang(Scots Gaelic)
			$$wlang("Serbo-Croat")
			$$wlang("Slovakian")
			$$wlang("Spanish")
			$$wlang("Swahili")
			$$wlang("Swedish")
			$$wlang("Tagalog")
			$$wlang("Thai")
			$$wlang("Turkish")
			$$wlang("Urdu")
			$$wlang("Vietnamese")
			$$wlang("Welsh")
			$$wlang("Xhosa")
			$$wlang("Yiddish")
			$$wlang("Zulu")
			end
		end
	sublist "Medical" memlist
		$$skill("Diagnosis", MH, "Medical;Science", "iq-6;firstaid-8;veterinary-5;physician-4", , tl)
		$$skill("First Aid", ME, "Medical", "physician;iq-5;veterinary-5;physiology-5", , tl)
		$$skill("Hypnotism", MH, "Pseudomedical")
		$$skill("Physician", MH, "Medical;Science", "veterinary-5;firstaid-11;iq-7", , tl)
		$$skill("Surgery", MVH, "Medical;Science", "veterinary-5;physician-5;physiology-8;firstaid-12", "Sk:Physician>=slc(12)", tl)
		end
	sublist "Military" memlist
		$$skill(Forward Observer, MA, Military, "iq-5", Configuration:TL>=6-&tl, tl/6+)
		$$skill(No-Landing Extraction, MA, Military, "iq-6", Config:TL>=7-&tl, tl/7+)
		$$skill(Nuclear-Biological-Chemical Warfare, MA, Military, "iq-5", Configuration:TL>=6-&tl, tl/6+)
		end
	sublist "Outdoor" memlist
		$$skill("Area Knowledge", ME, "Outdoor;Social", "iq-4")
		$$see("Boating", %-5l!PA)
		$$skill("Climbing", PA, "Outdoor;Thief/Spy;Sport", "skilldefST-5;dx-5#skilldefST")
		$$skill("Fishing", ME, "Outdoor;Sport", "iq-4")
		$$skill	Hard-Hat Diving	MA	Outdoor	scuba-2	Configuration:TL>=6-&tl	tl/6+
		$$skill	Hiking	PA/HT	Outdoor;Athletic;Sport
		$$see(Hunting, , , Tracking)
		$$sciskill("Naturalist", MH, "Outdoor;Scientific;Science", "iq-6")
		$$skill("Navigation", MH, "Outdoor", "astronomy-5;seamanship-5", , tl)
		$$skill	Orienteering	MA	Outdoor	iq-5
		$$skill("Seamanship", ME, "Outdoor", "iq-4", , tl)
		sublist Survival memlist
			$$skill("Survival", MA, "Outdoor;Survival", "iq-5;naturalist-3")
			$$skill("Survival (Desert)", MA, "Outdoor;Survival", "iq-5;naturalist-3;cat:'Survival'-3")
			$$skill("Survival (Plains)", MA, "Outdoor;Survival", "iq-5;naturalist-3;cat:'Survival'-3")
			$$skill("Survival (Arctic)", MA, "Outdoor;Survival", "iq-5;naturalist-3;cat:'Survival'-3")
			$$skill("Survival (Mountains)", MA, "Outdoor;Survival", "iq-5;naturalist-3;cat:'Survival'-3")
			$$skill("Survival (Radioactive)", MA, "Outdoor;Survival")
			$$skill("Survival (Woodlands)", MA, "Outdoor;Survival", "iq-5;naturalist-3;cat:'Survival'-3")
			$$skill("Survival (Jungle)", MA, "Outdoor;Survival", "iq-5;naturalist-3;cat:'Survival'-3")
			$$skill("Survival (Island/Beach)", MA, "Outdoor;Survival", "iq-5;naturalist-3;cat:'Survival'-3")
			$$skill("Survival (Swampland)", MA, "Outdoor;Survival", "iq-5;naturalist-3;cat:'Survival'-3")
			end
		$$skill("Tracking", MA, "Outdoor;Thief/Spy", "iq-5;Naturalist-5")
		end
	sublist "Professional" memlist
		$$skill("Accounting", MH, "Professional", "iq-10;merchant-5;mathematics-5", "Adv:Literacy|Configuration:TL>4-&tl")
		$$skill("Computer Operation", ME, "Professional", "iq-4", "Configuration:TL>=7-&tl", tl/7+)
		sublist "Electronics Operation" memlist
			$$skill("Electronics Operation", MA, "Professional;*Electronics Operation", "IQ-5;electronics-3", Config:TL>=6-&tl, tl/6+)
			$$skill("Electronics Operation (Communications)", MA, "Professional;*Electronics Operation", "IQ-5;electronicsoperationcommunications-3", Config:TL>=6-&tl, tl/6+)
			$$skill("Electronics Operation (Computers)", MA, "Professional;*Electronics Operation", "IQ-5;electronicsoperationcomputers-3", Config:TL>=7-&tl, tl/7+)
			$$skill("Electronics Operation (Force Shields)", MA, "Professional;*Electronics Operation", "IQ-5;electronicsoperationforceshields-3", Config:TL>=11-&tl, tl/11+)
			$$skill("Electronics Operation (Holographics)", MA, "Professional;*Electronics Operation", "IQ-5;electronicsoperationholographics-3", Config:TL>=8-&tl, tl/8+)
			$$skill("Electronics Operation (Matter Transmitters)", MA, "Professional;*Electronics Operation", "IQ-5;electronicsoperationmattertransmitters-3", Config:TL>=15-&tl, tl/15+)
			$$skill("Electronics Operation (Medical)", MA, "Professional;*Electronics Operation", "IQ-5;electronicsoperationmedical-3", , tl/6+)
			$$skill("Electronics Operation (Security Systems)", MA, "Professional;*Electronics Operation", "IQ-5;electronicsoperationsecuritysystems-3", Config:TL>=6-&tl, tl/6+)
			$$skill("Electronics Operation (Sensors)", MA, "Professional;*Electronics Operation", "IQ-5;electronicsoperationsensors-3", Config:TL>=6-&tl, tl/6+)
			$$skill("Electronics Operation (Weapons)", MA, "Professional;*Electronics Operation", "IQ-5;electronicsoperationweapons-3", Config:TL>=7-&tl, tl/7+)
			end
		$$skill("Freight Handling", MA, "Professional", "iq-6")
		$$skill("Heraldry", MA, "Professional", "iq-5;savoirfaire-3", "!Disadvantages:Non-Iconographic")
		$$skill("Law", MH, "Professional", "iq-6")
		$$genericSkill	Professional Skill		Professional	IQ-5
		end
	sublist "Scientific" memlist
		$$sciskill("Agronomy", MA, "Scientific;Science", "iq-5", , tl)
		$$sciskill("Alchemy", MVH, "Scientific;Occult;Scientific;Science", , , tl)
		$$sciskill("Anthropology", MH, "Scientific;Science", "iq-6")
		$$sciskill("Archaeology", MH, "Scientific;Science", "iq-6")
		$$sciskill("Architecture", MA, "Scientific", "iq-5", , tl)
		$$sciskill("Astrogation", MA, "Scientific;Science", "navigation-5;astronomy-4;mathematics-4", Config:TL>=7-&tl, tl/7+)
		$$sciskill("Astronomy", MH, "Scientific;Science", "iq-6", , tl)
		$$sciskill("Biochemistry", MVH, "Scientific;Science", "chemistry-5", "Chemistry>=slc(12)", tl)
		$$sciskill("Botany", MH, "Scientific;Science", "iq-6;agronomy-5;cat:'Planetology'-4", , tl)
		$$sciskill("Chemistry", MH, "Scientific;Science", "iq-6;alchemy-3", , tl)
		$$sciskill	Computer Hacking	MVH	Scientific;Thief/Spy;*Mathematical	ComputerOperation-8;ComputerProgramming-4	Configuration:TL>=7-&tl	tl/7+
		$$sciskill("Computer Programming", MH, "Scientific;Science;*Mathematical", , "Sk:Computer Operation>=slc(12);Conf:TL>=7", tl/7+)
		$$sciskill("Criminology", MA, "Scientific;*Empathic", "iq-4", , tl)
		$$sciskill("Cryptanalysis", MH, "Scientific;Military;*Mathematical", "iq-5;Mathematics-3;Cryptography-5;Cryptology-5", , tl)
		$$sciskill("Ecology", MH, "Scientific;Science", "iq-6;naturalist-3;cat:'Planetology'-4", , tl)
		$$sciskill("Economics", MH, "Scientific;Science", "iq-6;merchant-6")
		
		sublist "Electronics" memlist
			$$sciskill("Electronics", MH, "Scientific;Science;*Electronics", "cat:'Electronics'-4", "Sk:Mathematics>=slc(12);Conf:TL>=6", tl/6+)
			$$sciskill("Electronics (Communications)", MH, "Scientific;Science;*Electronics", "cat:'Electronics'-4", "Sk:Mathematics>=slc(12);Conf:TL>=6", tl/6+)
			$$sciskill("Electronics (Computers)", MH, "Scientific;Science;*Electronics", "cat:'Electronics'-4", "Sk:Mathematics>=slc(12);Conf:TL>=7", tl/7+)
			$$sciskill("Electronics (Force Shields)", MH, "Scientific;Science;*Electronics", "cat:'Electronics'-4", "Sk:Mathematics>=slc(12);Conf:TL>=11", tl/11+)
			$$sciskill("Electronics (Holographics)", MH, "Scientific;Science;*Electronics", "cat:'Electronics'-4", "Sk:Mathematics>=slc(12);Conf:TL>=8", tl/8+)
			$$sciskill("Electronics (Matter Transmitters)", MH, "Scientific;Science;*Electronics", "cat:'Electronics'-4", "Sk:Mathematics>=slc(12);Conf:TL>=15", tl/15+)
			$$sciskill("Electronics (Medical)", MH, "Scientific;Science;*Electronics", "cat:'Electronics'-4", "Sk:Mathematics>=slc(12);Conf:TL>=7", tl/7+)
			$$sciskill("Electronics (Security Systems)", MH, "Scientific;Science;*Electronics", "cat:'Electronics'-4", "Sk:Mathematics>=slc(12);Conf:TL>=7", tl/7+)
			$$sciskill("Electronics (Sensors)", MH, "Scientific;Science;*Electronics", "cat:'Electronics'-4", "Sk:Mathematics>=slc(12);Conf:TL>=8", tl/8+)
			$$sciskill("Electronics (Weapons)", MH, "Scientific;Science;*Electronics", "cat:'Electronics'-4", "Sk:Mathematics>=slc(12);Conf:TL>=7", tl/7+)
			end
		sublist "Engineer" memlist
			$$engskill("Engineer", MH, "Scientific;Engineering;Science", "mechanic-6", , tl)
			$$engskill("Engineer (Simple Machines)", MH, "Scientific;Engineering;Science", "mechanicsimplemachines-6", "Sk:Mechanic (Simple Machines)>=slc(12);Conf:TL>=2", tl/2+)
			$$engskill("Engineer (Aircraft)", MH, "Scientific;Engineering;Science", "mechanicaircraft-6", "Sk:Mechanic (Aircraft)>=slc(12)", tl)
			$$engskill("Engineer (Civil)", MH, "Scientific;Engineering;Science", , , tl)
			$$engskill("Engineer (Clockwork)", MH, "Scientific;Engineering;Science", "mechanicclockwork-6", "Sk:Mechanic (Clockwork)>=slc(12);Conf:TL>=4", tl/4+)
			$$engskill("Engineer (Combat)", MH, "Scientific;Engineering;Science", , , tl)
			$$engskill("Engineer (Electrical)", MH, "Scientific;Engineering;Science", , Conf:TL>=6, tl/6+)
			$$engskill("Engineer (Explosives)", MH, "Scientific;Engineering;Science", "traps-6", "Sk:Traps>=slc(12);Conf:TL>=4", tl/4+)
			$$engskill("Engineer (Guns)", MH, "Scientific;Engineering;Science", "armouryguns-6", "Conf:TL>=5", tl/5+)
			$$engskill("Engineer (Mining)", MH, "Scientific;Engineering;Science", "geology-6", "Sk:Geology>=slc(12)", tl)
			$$engskill("Engineer (Robotics)", MH, "Scientific;Engineering;Science", "mechanicrobotics-6", "Sk:Mechanic (Robotics)>=slc(12);Conf:TL>=7", tl/7+)
			$$engskill("Engineer (Spacecraft)", MH, "Scientific;Engineering;Science", "mechanicspacecraft-6", "Sk:Mechanic (Spacecraft)>=slc(12);Conf:TL>=7", tl/7+)
			$$engskill("Engineer (Vehicle)", MH, "Scientific;Engineering;Science", "mechanicvehicle-6", "Sk:Mechanic (Vehicle)>=slc(12)", tl)
			$$engskill("Engineer (Steam Engine)", MH, "Scientific;Engineering;Science", "mechanicsteamengine-6", "Sk:Mechanic (Steam Engine)>=slc(12);Conf:TL>=5", tl/5+)
			$$engskill("Engineer (Marine Vessel)", MH, "Scientific;Engineering;Science", "mechanicmarinevessel-6", "Sk:Mechanic (Marine Vessel)>=slc(12);Conf:TL>=5", tl/5+)
			$$engskill("Engineer (Plumbing)", MH, "Scientific;Engineering;Science", , , tl)
			end
		
		$$sciskill("Forensics", MH, "Scientific;Science", "criminology-4", , tl)
		$$sciskill("Genetics", MVH, "Scientific;Science", "biochemistry-5;physiology-5", , tl)
		$$sciskill("Geology", MH, "Scientific;Science", "iq-6;prospecting-4;cat:'Planetology'-3", , tl)
		$$sciskill("History", MH, "Scientific", "iq-6;archaeology-6")
		$$sciskill("Linguistics", MVH, "Scientific;Science", , , , , , "Sk:Language+integer(x/10)")
		$$sciskill("Literature", MH, "Scientific", "iq-6")
		$$sciskill("Mathematics", MH, "Scientific;Science;*Mathematical", "iq-6", "!Disadvantages:Innumerate")
		$$sciskill("Metallurgy", MH, "Scientific;Science", "blacksmith-8;jeweler-8;armoury-8;chemistry-5", , tl)
		$$sciskill("Meteorology", MA, "Scientific;Science", "iq-5;cat:'Planetology'-3", , tl)
		
		$$see("Naturalist", %-5l!MH)
		$$sciskill("Nuclear Physics", MVH, "Scientific;Science", , "Physics>=15;Mathematics>=15", tl)
		$$sciskill("Occultism", MA, "Scientific;Occult", "iq-6")
		$$sciskill(Philosophy, MH, "Scientific", "iq-6")
		$$sciskill("Physics", MH, "Scientific;Science", "iq-6", , tl)
		$$sciskill("Physiology", MVH, "Scientific;Science", "iq-7;physician-5;firstaid-5;cat:'Medical'-5", , tl)
		sublist Planetology memlist
			$$sciskill	Planetology	MA	Scientific;*Planetology	iq-5;Geology-4;Meteorology-4;cat:'Planetology'-3
			$$sciskill	Planetology (Rock/Ice Worlds)	MA	Scientific;*Planetology	iq-5;Geology-4;Meteorology-4;cat:'Planetology'-3
			$$sciskill	Planetology (Earth-like)	MA	Scientific;*Planetology	iq-5;Geology-4;Meteorology-4;cat:'Planetology'-3
			$$sciskill	Planetology (Hostile Terrestrial)	MA	Scientific;*Planetology	iq-5;Geology-4;Meteorology-4;cat:'Planetology'-3
			$$sciskill	Planetology (Gas Giants)	MA	Scientific;*Planetology	iq-5;Geology-4;Meteorology-4;cat:'Planetology'-3
			end
		$$sciskill("Prospecting", MA, "Scientific", "iq-5;geology-4")
		$$sciskill(Psychology, MH, "Scientific;Science;*Empathic", "iq-6+(empathyBonus?3:0)", , , "mmh(~x-(empathyBonus?3:0),iq)",
			, , , "%0ln^x|doptlist('Specialty')|%-18ll%-12rc%-7rx|format('%d%s',@v@,@bonus@ or empathyBonus?'*':'')|")
		$$sciskill("Research", MA, "Scientific", "iq-5;writing-3")
		$$sciskill("Theology", MH, "Scientific", "iq-6")
		
		$$sciskill	Xenobiology	MA	Scientific		Configuration:TL>=7-&tl	tl
		$$sciskill	Xenology	MH	Scientific;Science	iq-6	Configuration:TL>=7-&tl	tl
		$$sciskill("Zoology", MH, "Scientific;Science", "iq-6;animalhandling-6;cat:'Planetology'-4;cat:'Animal'-6")
		end
	sublist "Social" memlist
		$$skill("Acting", MA, "Social;Thief/Spy;*Performance;*Empathic", "iq-5;bard-5;performanceskill-2")
		$$skill("Administration", MA, "Social", "iq-6;merchant-3")
		$$skill("Area Knowledge", ME, "Outdoor;Social", "iq-4")
		$$see("Bard", %-5l!MA)
		$$skill("Carousing", PA!/HT, "Social;*Empathic", "ht-4")
		$$skill("Diplomacy", MH, "Social;*Empathic", "iq-6")
		$$skill("Fast-Talk", MA, "Social;Thief/Spy;*Empathic", "iq-5;acting-5")
		$$skill("Gambling", MA, "Social", "iq-5;mathematics-5")
		$$skill("Intimidation", MA, "Social;*Empathic", "skilldefST-5;acting-3")
		$$skill("Leadership", MA, "Social;*Empathic", "skilldefST-5")
		$$skill("Merchant", MA, "Social;*Empathic", "iq-5")
		$$skill("Performance", MA, "Social;*Performance", "iq-5;acting-2;bard-2", , , , , , PerformanceSkill)
		$$skill("Politics", MA, "Social;*Empathic", "iq-5;diplomacy-5")
		$$see("Public Speaking", %-5l!MA, , Bard)
		$$skill("Savoir-Faire", ME, "Social;*Empathic;*Savoir-Faire", "iq+(status>0?2:-4);savoirfaireservant-2#status", , , "MME(~x,iq)+0*status")
			opt
				begin exp "Base Level" "status>0?iq:0" noprint end
				end
		$$skill("Savoir-Faire (Own Culture)", ME, "Social;*Empathic;*Savoir-Faire", "iq+(status>0?0:-4);savoirfaireservant-2#status", , , "MME(~x,iq)+0*status")
			opt
				begin exp "Base Level" "status>0?iq+2:0" noprint end
				end
		$$skill("Sex Appeal", MA/HT, "Social;*Empathic", "ht-3", , , "ma(~x,ht)*IQM")
		$$skill("Strategy", MH, "Social", "iq-6;tactics-6")
		$$skill("Tactics", MH, "Social", "iq-6;strategy-6")
		$$skill("Teaching", MA, "Social", "iq-5")
		end
	sublist "Thief/Spy" memlist
		$$see("Acting", %-5l!MA)
		$$skill("Camouflage", ME, "Thief/Spy", "iq-4;cat:'Survival'-2")
		$$see("Climbing", %-5l!PA)
		$$skill("Demolition", MA, "Thief/Spy", "iq-5;engineerexplosives-3", Conf:TL>=4, tl/4+)
		$$skill("Detect Lies", MH, "Thief/Spy;*Empathic", "iq-6+(empathyBonus?4:0);psychology-4", , , "mmh(~x-(empathyBonus?4:0),iq)",
			, , , "%0ln^x|doptlist('Specialty')|%-18ll%-12rc%-7rx|format('%d%s',@v@,@bonus@ or empathyBonus?'*':'')|")
		$$skill("Disguise", MA, "Thief/Spy", "iq-5")
		$$skill("Escape", PH, "Thief/Spy", "dx-6")
		$$see("Fast-Talk", %-5l!MA)
		$$skill("Forgery", MH, "Thief/Spy", "iq-6;dx-8;artist-5#dx", , tl)
		$$skill("Holdout", MA, "Thief/Spy", "iq-5;sleightofhand-3")
		$$skill("Intelligence Analysis", MH, "Thief/Spy;Military", "iq-6")
		$$skill("Interrogation", MA, "Thief/Spy", "iq-5")
		$$skill("Lip Reading", MA, "Thief/Spy", "iq+&vision-10")
		$$skill("Lockpicking", MA, "Thief/Spy", "iq-5", , tl)
		$$skill("Pickpocket", PH, "Thief/Spy;*Manual", "dx-6;sleightofhand-4")
		$$skill("Poisons", MH, "Thief/Spy", "iq-6;chemistry-5;physician-3")
		$$skill("Scrounging", ME, "Thief/Spy", "iq-4")
		$$skill("Shadowing", MA, "Thief/Spy", "iq-6;stealth-4")
		$$skill("Sleight of Hand", PH, "Thief/Spy;*Manual")
		$$skill("Stealth", PA, "Thief/Spy", "iq-5;dx-5#iq")
		$$skill("Streetwise", MA, "Thief/Spy;*Empathic", "iq-5")
		$$see("Tracking", %-5l!MA)
		$$skill("Traps", MA, "Thief/Spy", "iq-5;dx-5;lockpicking-3#dx", , tl)
		$$skill("Underwater Demolition", MA, "Thief/Spy", "demolition-2", "Sk:Scuba>=slc(12);Sk:Demolition>=slc(12)|Sk:Engineer (Explosives)>=slc(12)", tl)
		$$skill("Ventriloquism", MH, "Thief/Spy")
		end
	sublist "Vehicle" memlist
		$$see("Battlesuit", %-5l!PA)
		$$skill("Bicycling", PE, "Vehicle;Sport", "dx-4;motorcycle")
		$$skill("Boating", PA, "Outdoor;Vehicle;Sport", "iq-5;dx-5;powerboat-3#iq")
		sublist "Driving" memlist
			$$skill("Driving", PA, "Vehicle;*Driving", "iq-5;dx-5;cat:'Driving'-4#iq", , tl, , , , Driving)
			$$skill("Driving (Automobile)", PA, "Vehicle;*Driving;Sport", "iq-5;dx-5;DrvHvyWh-2;cat:'Driving'-4#iq", Conf:TL>=6, tl/6+, , , , DrvAuto)
			##skill("Driving (All-Terrain Vehicle)", PA, "Vehicle;*Driving", "iq-5;dx-5;cat:'Driving'-4#iq", Conf:TL>=6, tl/6+, , , , DrvATV)
			$$skill("Driving (Construction Equipment)", PA, "Vehicle;*Driving", "iq-5;dx-5;cat:'Driving'-5#iq", Conf:TL>=6, tl/6+, , , , DrvConstEq)
			$$skill("Driving (Heavy Wheeled)", PA, "Vehicle;*Driving", "iq-5;dx-5;cat:'DrvAuto-2;Driving'-4#iq", Conf:TL>=6, tl/6+, , , , DrvHvyWh)
			$$skill("Driving (Hovercraft)", PA, "Vehicle;*Driving", "iq-5;dx-5;cat:'Driving'-5#iq", Conf:TL>=7, tl/7+, , , , DrvHover)
			$$skill("Driving (Locomotive)", PA, "Vehicle;*Driving", "iq-5;dx-5;cat:'Driving'-5#iq", Conf:TL>=5, tl/5+, , , , DrvLoco)
			##skill("Driving (Racing Car)", PA, "Vehicle;*Driving", "iq-5;dx-5;cat:'Driving'-4#iq", Conf:TL>=6, tl/6+, , , , DrvRacCar)
			##skill("Driving (Snowmobile)", PA, "Vehicle;*Driving", "iq-5;dx-5;cat:'Driving'-4#iq", Conf:TL>=6, tl/6+, , , , DrvSnowm)
			$$skill("Driving (Halftrack)", PA, "Vehicle;*Driving", "iq-5;dx-5;DrvTrk-2;cat:'Driving'-4#iq", Conf:TL>=6, tl/6+, , , , DrvHlfTrk)
			$$skill("Driving (Tracked)", PA, "Vehicle;*Driving", "iq-5;dx-5;DrvHlfTrk-2;cat:'Driving'-4#iq", Conf:TL>=6, tl/6+, , , , DrvTrk)
			$$see("Driving (Tank)", , , "Driving (Tracked)")
			##skill("Driving (Trike)", PA, "Vehicle;*Driving", "iq-5;dx-5;cat:'Driving'-4#iq", Conf:TL>=6, tl/6+, , , , DrvTrike)
			$$skill("Driving (Mecha)", PA, "Vehicle;*Driving", "iq-5;dx-5;exoskeleton-3;battlesuit-3;cat:'Driving'-5#iq", Conf:TL>=8, tl/8+, , , , DrvMecha)
			end
		$$skill	Exoskeleton	PA	Vehicle	iq-6;dx-6;battlesuit-2#iq	Configuration:TL>=7-&tl	tl/7+
		$$see(Gunner Skills, , Gunner)
		$$see(Mechanic, , Mechanics)
		$$skill("Motorcycle", PE, "Vehicle", "dx-5;iq-5;bicycling-5#iq", Conf:TL>=6, tl/6+)
		sublist "Piloting" memlist
			$$skill("Piloting", PA, "Vehicle;Piloting", "iq-6;cat:'Piloting'-4", Conf:TL>=6, tl/6+)
			$$skill("Piloting (Glider)", PA, "Vehicle;Piloting", "iq-6;cat:'Piloting'-4", Conf:TL>=6, tl/6+)
			$$skill("Piloting (Sailing)", PA, "Vehicle;Piloting", "iq-6;cat:'Piloting'-4", , tl)
			$$skill("Piloting (Lighter-than-Air)", PA, "Vehicle;Piloting", "iq-6;cat:'Piloting'-4", Conf:TL>=6, tl/6+)
			$$skill("Piloting (Balloon)", PA, "Vehicle;Piloting", "iq-6;cat:'Piloting'-4", Conf:TL>=5, tl/5+)
			$$skill("Piloting (Fighter Spacecraft)", PA, "Vehicle;Piloting", "iq-6;cat:'Piloting'-4", Conf:TL>=8, tl/8+)
			$$skill("Piloting (Hovercraft)", PA, "Vehicle;Piloting", "iq-6;cat:'Piloting'-4", Conf:TL>=7, tl/7+)
			$$skill("Piloting (Ultralight)", PA, "Vehicle;Piloting", "iq-6;cat:'Piloting'-4", Conf:TL>=7, tl/7+)
			$$skill("Piloting (Single-Engine Prop)", PA, "Vehicle;Piloting", "iq-6;cat:'Piloting'-4", Conf:TL>=6, tl/6+)
			$$skill("Piloting (Twin-Engine Prop)", PA, "Vehicle;Piloting", "iq-6;cat:'Piloting'-4", Conf:TL>=6, tl/6+)
			$$skill("Piloting (Multi-Engine Prop)", PA, "Vehicle;Piloting", "iq-6;cat:'Piloting'-4", Conf:TL>=6, tl/6+)
			$$skill("Piloting (Mecha)", PA, "Vehicle;Piloting", "iq-6;cat:'Piloting'-4", Conf:TL>=8, tl/8+)
			$$skill("Piloting (Military Jet)", PA, "Vehicle;Piloting", "iq-6;cat:'Piloting'-4", Conf:TL>=7, tl/7+)
			$$skill("Piloting (Spacecraft)", PA, "Vehicle;Piloting", "iq-6;cat:'Piloting'-4", Conf:TL>=7, tl/7+)
			$$skill("Piloting (Space Shuttle)", PA, "Vehicle;Piloting", "iq-6;cat:'Piloting'-4", Conf:TL>=7, tl/7+)
			$$skill("Piloting (Starship)", PA, "Vehicle;Piloting", "iq-6;cat:'Piloting'-4", Conf:TL>=8, tl/8+)
			$$skill("Piloting (Small Private Jet)", PA, "Vehicle;Piloting", "iq-6;cat:'Piloting'-4", Conf:TL>=7, tl/7+)
			$$skill("Piloting (Multi-Engine Jet)", PA, "Vehicle;Piloting", "iq-6;cat:'Piloting'-4", Conf:TL>=7, tl/7+)
			$$skill("Piloting (Contragravity)", PA, "Vehicle;Piloting", "iq-6;cat:'Piloting'-4", Conf:TL>=12, tl/12+)
			$$skill("Piloting (Jet Pack)", PA, "Vehicle;Piloting", "iq-6;cat:'Piloting'-4", Conf:TL>=7, tl/7+)
			$$skill("Piloting (Ornithopter)", PA, "Vehicle;Piloting", "iq-6;cat:'Piloting'-4", Conf:TL>=7, tl/7+)
			$$skill("Piloting (Rotary Wing)", PA, "Vehicle;Piloting", "iq-6;cat:'Piloting'-4", Conf:TL>=7, tl/7+)
			$$skill("Piloting (Vertol)", PA, "Vehicle;Piloting", "iq-6;cat:'Piloting'-4", Conf:TL>=7, tl/7+)
			end
		$$skill("Powerboat", PA, "Vehicle;Sport", "iq-5;dx-5;boating-3#iq", Conf:TL>=6, tl/6+)
		$$see("Teamster", %-5l!MA)
		$$skill("Vacc Suit", MA, "Vehicle", "iq-6", "Sk:Free Fall>=slc(12);Conf:TL>=7", tl/7+)
		end
	end
	
cat Spells
	$$note(--)
		textline rand -1 dupexpected
	$$note(Note)
		textline rand -1
	$$sublist(Sublist)
		textline rand -1

	sublist "Air" memlist
		$$sp("Breathe Water", Regular, , "Air;Water", "1 sec.", "1 min.", "4/2", "Create Air>=slc(12);Destroy Water>=slc(12)", M35;B157)
		$$sp("Control Air Elemental", Special, , "Air", "2 sec.", "1 min.", "Special", "Summon Air Elemental>=slc(12)", M33;B157)
		$$sp("Create Air", "Area", , "Air;*Create", , "5 sec.#", "1", "Purify Air>=slc(12)|Seek Air>=slc(12)", M34;B157)
		$$sp("Create Air", "Area", , "Air;*Create", , "5 sec.#", "1", "Purify Air>=slc(12)", M34;B157)
			textline dsid ALTS
		$$sp("Create Air Elemental", Special, , "Air", "Special", "Perm.", "Special", "Control Air Elemental>=slc(12)", M33;B157)
		$$sp("Purify Air", , , "Air", "1 sec.", "Instant", "1", , M34;B157)
		$$sp("Purify Air", , , "Air", "1 sec.", "Instant", "1", "Seek Air>=slc(12)", M34;B157)
			textline dsid ALTS
		$$sp("Shape Air", Regular, , "Air;*Shape", "1 sec.", "1 min.", "1 to 10#", "Create Air>=slc(12)", M34;B157)
		$$sp("Summon Air Elemental", Special, , "Air;*Summon Elemental", "30 sec.", "1 hr.#", "4", "#1,Adv:Magery>=1~#8,Sp:Air>=slc(12)|#4,Sp:Air>=slc(12);#1,Sp:*Summon Elemental>=slc(12)", M33;B156)
		$$sp("Walk on Air", Regular, , "Air", "1 sec.", "1 min.", "3/2", "Shape Air>=slc(12)", M35;B157)
		sublist "Weather" memlist
			$$sp("Predict Weather", Information, , "Air;*Weather", "5 sec.", "Instant", "varies#", "#4,Sp:Air>=slc(12)", M35;B157)
			$$sp("Clouds", Area, , "Air;*Weather", "10 sec.", "10 min.", "1/20/s", "#4,Sp:Water>=slc(12);#4,Sp:Air>=slc(12)", M35;B157)
			$$sp("Rain", Area, , "Air;Water;*Weather", "1 min.", "1 hr.", "1/10/s.", "Clouds>=slc(12)", M35;B157)
			end
		sublist "Electricity" memlist
			$$sp("Lightning", Missile, , "Air;*Electricity", "1 to 3 sec.", "Instant", "1 to 3#", "#6,Sp:Air>=slc(12)", M36;B158)
			end
		end
	sublist "Animal" memlist
		$$sp("Beast Summoning", Regular, , "Animal", "1 sec.", "1 min.", "3/2#", "Beast-Soother>=slc(12)", M23;B155, "BeastKin?asp(~x,iq):hsp(~x,iq)")
		$$sp("Beast-Soother", Regular, , "Animal", "1 sec.", "Perm.#", "1 to 3", "Persuasion>=slc(12)|Adv:Animal Empathy", M23;B155, "BeastKin?asp(~x,iq):hsp(~x,iq)")
		$$sp("Bird Control", Regular, "IQ", "Animal;*Animal Control", "1 sec.", "1 min.", "4/2", "Beast-Soother>=slc(12)", M24;B155, "BeastKin?asp(~x,iq):hsp(~x,iq)")
		$$sp("Mammal Control", Regular, "IQ", "Animal;*Animal Control", "1 sec.", "1 min.", "5/3", "Beast-Soother>=slc(12)|Charm>=slc(12)", M24;B155, "BeastKin?asp(~x,iq):hsp(~x,iq)")
		$$sp("Reptile Control", Regular, "IQ", "Animal;*Animal Control", "1 sec.", "1 min.", "4/2", "Beast-Soother>=slc(12)", M24;B155, "BeastKin?asp(~x,iq):hsp(~x,iq)")
		end
	sublist "Body Control" memlist
		end
	sublist "Communication and Empathy" memlist
		$$sp("Mind-Reading", Regular, "IQ", "Communication and Empathy", "10 sec.", "1 min.", "4/2", "Truthsayer>=slc(12)", M28;B155)
		$$sp("Persuasion", Regular, "IQ", "Communication and Empathy", "1 sec.", "1 min.", "2 x bonus#", "Sense Emotion>=slc(12)", M29;B155)
		$$sp("Sense Emotion", Regular, , "Communication and Empathy", "1 sec.", "Instant", "2", "Sense Foes>=slc(12)", M28;B155)
		$$sp("Sense Foes", Inform./Area, , "Communication and Empathy", "1 sec.", "Instant", "1 (min. 2)#", , M28;B155)
		$$sp("Sense Life", Inform., , "Communication and Empathy", "1 sec.", "Instant", "1/2 (min. 1)#", , M28;B155)
		$$sp("Truthsayer", Inform, "IQ", "Communication and Empathy", "1 sec.", "Instant", "2", "Sense Emotion>=slc(12)", M28;B155)
		end
	sublist "Earth" memlist
		$$sp("Control Earth Elemental", Special, "ST or IQ", "Earth", "2 sec.", "1 min.", "Special", "Summon Earth Elemental>=slc(12)", M33;B157)
		$$sp("Create Earth", , , "Earth;*Create", , "Perm.", "4/hex#", "Earth to Stone>=slc(12)", M32;B156)
		$$sp("Create Earth Elemental", Special, , "Earth", "Special", "Perm.", "Special", "Control Earth Elemental>=slc(12)", M33;B157)
		$$sp("Earth to Air", , , "Earth;Air;*Transmutation", "2 sec.", "Perm.", "8/hex#", "Create Air>=slc(12);Shape Earth>=slc(12)", M32;B156)
		$$sp("Earth to Stone", , , "Earth;*Transmutation", "1 sec.", "Perm.", "5/hex#", "#1,Adv:Magery>=1;Shape Earth>=slc(12)", M32;B156)
		$$sp("Earth Vision", Regular, , "Earth;Knowledge", "1 sec.", "30 sec.", "2/10 yds#", "Shape Earth>=slc(12)", M32;B156)
		$$sp("Seek Earth", Information, , "Earth;*Seek", "10 sec.", "Instant", "3", , M31;B156)
		$$sp("Shape Earth", , , "Earth;*Shape", , , "2/hex/1/hex", "Seek Earth>=slc(12)", M31;B156)
		$$sp("Stone Missile", Missile, , "Earth", "1/energy pt.", "Instant", "1 to 3#", "Create Earth>=slc(12)", M32;B156)
		$$sp("Stone to Earth", , , "Earth;*Transmutation", "1 sec.", "Perm.", "10/hex#", "Earth to Stone>=slc(12)|#4,Sp:Earth>=slc(12)", M32;B156)
		$$sp("Summon Earth Elemental", Special, , "Earth;*Summon Elemental", "30 sec.", "1 hr.#", "4", "#1,Adv:Magery>=1~#8,Sp:Earth>=slc(12)|#4,Sp:Earth>=slc(12);#1,Sp:*Summon Elemental>=slc(12)", M33;B156)
		end
	sublist "Enchantment" memlist
		$$sp("Enchant*", Enchantment, , "Enchantment", "varies#", "Perm.", "varies#", "#1,Adv:Magery>=2;#1,10,Sp>=slc(12)", M42;B160)
		$$sp("Power", Enchantment, , "Enchantment", , "Perm.", "varies#", "Enchant>=slc(12);Recover Strength>=slc(12)", M43;B160)
		$$sp("Remove Enchantment", Enchantment, , "Enchantment", "varies#", "Perm.", "100#", "Enchant>=slc(12)", M43;B160)
		$$sp("Scroll", Enchantment, , "Enchantment", "days = cost", "varies#", "Special", "#1,Adv:Magery>=1~Adv:Literacy|Configuration:TL>4-&tl", M42;B160)
		sublist "Weapon Enchantments" memlist
			$$sp("Accuracy", Enchantment, , "Enchantment;*Weapon Enchantment", , "Perm.", "varies#", "Enchant>=slc(12);#5,Sp:Air>=slc(12)", M44;B160)
			$$sp("Puissance", Enchantment, , "Enchantment;*Weapon Enchantment", , "Perm.", "varies#", "Enchant>=slc(12);#5,Sp:Earth>=slc(12)", M44;B160)
			end
		sublist "Armor Enchantments" memlist
			$$sp("Fortify", Enchantment, , "Enchantment", , "Perm.", "varies#", "Enchant>=slc(12)", M46;B161)
			$$sp("Deflect", Enchantment, , "Enchantment", , "Perm.", "varies#", "Enchant>=slc(12)", M46;B161)
			$$sp("Lighten", Enchantment, , "Enchantment", , "Perm.", "varies#", "Enchant>=slc(12)", M46;B161)
			end
		sublist "Wizardly Tools" memlist
			$$sp("Staff", Enchantment, , "Enchantment", , "Perm.", "30", "Enchant>=slc(12)", M47;B161)
			$$sp("Powerstone", Enchantment, , "Enchantment", , "Perm.", "20 per casting", "Enchant>=slc(12)", M47;B161)
			end
		end
	sublist "Fire" memlist
		$$sp("Cold", Regular, , "Fire", "1 min.", "1 min.", "3/hex#", "Heat>=slc(12)", M37;B159)
		$$sp("Control Fire Elemental", Special, , "Fire", "2 sec.", "1 min.", "Special", "Summon Fire Elemental>=slc(12)", M33;B157)
		$$sp("Create Fire", "Area", , "Fire;*Create", , , "2/1", "Ignite Fire>=slc(12)|Seek Fire>=slc(12)", M36;B158)
		$$sp("Create Fire Elemental", Special, , "Fire", "Special", "Perm.", "Special", "Control Fire Elemental>=slc(12)", M33;B157)
		$$sp("Extinguish Fire", Regular, , "Fire", "1 sec.", "Perm.", "3/hex", "Ignite Fire>=slc(12)", M37;B158)
		$$sp("Fireball", Missile, , "Fire", "1-3 sec.", "Instant", "1 to 3#", "#1,Adv:Magery>=1;Create Fire>=slc(12);Shape Fire>=slc(12)", M37;B159)
		$$sp("Heat", Regular, , "Fire", "1 min.", "1 min.", "3/hex#", "Create Fire>=slc(12);Shape Fire>=slc(12)", M37;B158)
		$$sp("Ignite Fire", , , "Fire;*Shape", "1 sec.", "1 sec.", "1 to 4 #", , M36;B158)
		$$sp("Resist Fire", Regular, , "Fire", "1 sec.", "1 min.", "2/hex#", "Extinguish Fire>=slc(12);Cold>=slc(12)", M37;B159)
		$$sp("Shape Fire", Area, , "Fire", "1 sec.", "1 min.", "2/1", "Ignite Fire>=slc(12)", M37;B158)
		$$sp("Summon Fire Elemental", Special, , "Fire;*Summon Elemental", "30 sec.", "1 hr.#", "4", "#1,Adv:Magery>=1~#8,Sp:Fire>=slc(12)|#4,Sp:Fire>=slc(12);#1,Sp:*Summon Elemental>=slc(12)", M33;B156)
		end
	sublist "Food" memlist
		end
	sublist "Generic" 
			textline rand -1
		memlist
		$$sp("Hard Spell", , , "Generic")
			textline rand -1
		$$sp("Hard Spell/TL/TL", , , "Generic")
			textline rand -1
		$$sp("Very Hard Spell*", , , "Generic")
			textline rand -1
		$$sp("Very Hard Spell/TL/TL*", , , "Generic")
			textline rand -1
		end
	sublist "Healing" memlist
		$$sp("Awaken", "Area", , "Healing", "1 sec.", "Instant", "1", "Lend Health>=slc(12)", M49;B162)
		$$sp("Lend Health", Regular, , "Healing", "1 sec.", "1 hr.", "1 per HT loaned", "Lend Strength>=slc(12)", M49;B162)
		$$sp("Lend Strength", Regular, , "Healing", "1 sec.", "Perm.", "varies#", "#1,Adv:Magery>=1|Adv:Empathy", M49;B162)
		$$sp("Major Healing*", Regular, , "Healing", "1 sec.", "Perm.", "1 to 4#", "Minor Healing>=slc(12);#1,Adv:Magery>=1", M50;B162)
		$$sp("Minor Healing", Regular, , "Healing", "1 sec.", "Perm.", "1 to 3#", "Lend Health>=slc(12)", M50;B162)
		$$sp("Recover Strength", Special, , "Healing", "Special", "Special", "none", "#1,Adv:Magery>=1;Lend Strength>=slc(12)", M49;B162)
		end
	sublist "Illusion and Creation" memlist
		end
	sublist "Knowledge" memlist
		$$sp("Analyze Magic", Inform., "spell", "Knowledge", "1 hr.", "Instant", "8", "Identify Spell>=slc(12)", M55;B163)
		$$sp("Aura", Information, , "Knowledge", "1 sec.", "Instant", "3", "Detect Magic>=slc(12)", M53;B163)
		$$sp("Detect Magic", Regular, , "Knowledge", "5 sec.", "Instant", "2", "#1,Adv:Magery>=1", M53;B162)
		$$sp("Identify Spell", Information, , "Knowledge", "1 sec.", "Instant", "2", "Detect Magic>=slc(12)", M55;B163)
		$$sp("Seeker", Information, , "Knowledge", "1 sec.", "Instant", "3#", "#1,Adv:Magery>=1;Main:IQ>=12;#2,Sp:*Seek>=slc(12)", M54;B163)
		$$sp("Trace", Regular, , "Knowledge", "1 min.", "1 hr.#", "3/1", "Seeker>=slc(12)", M54;B163)
		end
	sublist "Light and Darkness" memlist
		$$sp("Blur", Regular, , "Light and Darkness", "2 sec.", "1 min.", "1 to 5/s", "Darkness>=slc(12)", M58;B163)
		$$sp("Continual Light", Regular, , "Light and Darkness", "1 sec.", "varies#", "varies#", "Light>=slc(12)", M57;B163)
		$$sp("Darkness", Area, , "Light and Darkness", "1 sec.", "1 min.", "2/1", "Continual Light>=slc(12)", M58;B163)
		$$sp("Flash", Regular, , "Light and Darkness", "2 sec.", "Instant", "4", "Continual Light>=slc(12)", M57;B163)
		$$sp("Light", , , "Light and Darkness", "1 sec.", "1 min.", "1/1", , M57;B163)
		end
	sublist "Making and Breaking" memlist
		$$sp("Find Weakness/TL", Information, , "Making and Breaking", 2 sec, Instant, "1#", "#1,Sp:Air>=slc(12);#1,Sp:Earth>=slc(12);#1,Sp:Fire>=slc(12);#1,Sp:Water>=slc(12)", M59;B164)
		$$sp("Restore", Regular, , "Making and Breaking", "3 sec.", "10 min.", "2 per hex/h", "Weaken>=slc(12)|Simple Illusion>=slc(12)", M59;B164)
		$$sp("Shatter*", Regular, , "Making and Breaking", "1 sec.", "Instant", "1 to 3#", "#1,Adv:Magery>=1;Weaken>=slc(12)", M59;B164)
		$$sp("Weaken", Regular, , "Making and Breaking", "5 sec.", "Perm.", "2", "Find Weakness>=slc(12)", M59;B164)
		end
	sublist "Meta-Spell" memlist
		end
	sublist "Mind Control" memlist
		$$sp("Bravery", Area, "IQ-1", "Mind Control", "1 sec.", "1 hr.#", "2", "Fear>=slc(12)", M65;B164)
		$$sp("Daze", Regular, "HT", "Mind Control", "1 sec.", "1 min.", "3/2", "Foolishness>=slc(12)", M66;B164)
		$$sp("Fear", Area, "IQ", "Mind Control", "1 sec.", "10 min.#", "1", "Sense Emotion>=slc(12)", M65;B164)
		$$sp("Foolishness", Regular, "IQ", "Mind Control", "1 sec.", "1 min.", "1 per IQ./h", "Main:IQ>=12", M66;B164)
		$$sp("Mass Daze", Area, "HT", "Mind Control", "sec. = cost", "Instant", "2/1#", "Daze>=slc(12);Main:IQ>=13", M66;B164)
		$$sp("Mass Sleep", Area, "HT", "Mind Control", "sec. = cost", "Instant", "3#", "Sleep>=slc(12);Main:IQ>=13", M66;B164)
		$$sp("Sleep", Regular, "HT", "Mind Control", "3 sec.", "Instant", "4", "Daze>=slc(12)", M66;B164)
		end
	sublist "Movement" memlist
		end
	sublist "Necromantic" memlist
		end
	sublist "Plant" memlist
		end
	sublist "Protection and Warning" memlist
		end
	sublist "Sound" memlist
		end
	sublist "Water" memlist
		$$sp("Control Water Elemental", Special, , "Water", "2 sec.", "1 min.", "Special", "Summon Water Elemental>=slc(12)", M33;B157)
		$$sp("Create Water", , , "Water;*Create", , "Perm.", "2/gal.", "Purify Water>=slc(12)", M39;B159)
		$$sp("Create Water Elemental", Special, , "Water", "Special", "Perm.", "Special", "Control Water Elemental>=slc(12)", M33;B157)
		$$sp("Destroy Water", Area, , "Water", "1 sec.", "Perm.", "3", "Create Water>=slc(12)", M38;B159)
		$$sp("Purify Water", Special, , "Water", "5-10 sec./gal.", "Perm.", "1/gal.", "Seek Water>=slc(12)", M39;B159)
		$$sp("Seek Water", Information, , "Water;*Seek", "1 sec.", "Instant", "2", , M39;B159)
		$$sp("Shape Water", , , "Water;*Shape", "2 sec.", , "1/1#", "Create Water>=slc(12)", M39;B159)
		$$sp("Summon Water Elemental", Special, , "Water;*Summon Elemental", "30 sec.", "1 hr.#", "4", "#1,Adv:Magery>=1~#8,Sp:Water>=slc(12)|#4,Sp:Water>=slc(12);#1,Sp:*Summon Elemental>=slc(12)", M33;B156)
		$$sp("Walk on Water", Regular, , "Water", "4 sec.", "1 min.", "3/2", "Shape Water>=slc(12)", M40;B159)
		sublist "Weather" memlist
			$$sp("Fog", Area, , "Water;*Weather", "1 sec.", "1 min.", "2/1", "Shape Water>=slc(12)", M40;B159)
			end
		sublist "Ice" memlist
			$$sp("Ice Sphere", Missile, , "Water;*Ice", "1-3 sec.", "Instant", "1-3#", "Shape Water>=slc(12)", M41;B160)
			end
		end
	end

cat "Powers"
	$$note(--)
		textline rand -1 dupexpected
	$$note(Note)
		textline rand -1
	$$sublist(Sublist)
		textline rand -1
	sublist Generic 
			textline rand -1
		memlist
		$$suppow("Generic Area/Mental Power", AM, 5, iq)
			textline rand -1
			opt
				begin text "LC" "??5;5;x" noprint end
				end
		$$suppow("Generic Ranged/Mental Power", RM, 5, iq)
			textline rand -1
			opt
				begin text "LC" "??5;5;x" noprint end
				end
		$$suppow("Generic Ranged/Physical Power", RP, 5, dx)
			textline rand -1
			opt
				begin text "LC" "??5;5;x" noprint end
				end
		$$suppow("Generic Area/Physical Power", AP, 5, dx)
			textline rand -1
			opt
				begin text "LC" "??5;5;x" noprint end
				end
		$$suppow("Generic Attack Power", RP, 6, dx)
			textline rand -1
			opt
				begin text "LC" "??6;6;x" noprint end
				end
			$$supdmg()
		end
	end

cat "Time Use"
	$$timeuse	Time Use
	$$timeuse	Traveling
	$$timeuse	Enchanting
		opt
			begin percent "Automatic Spell Study" "??50;50;x;x>=0 and x<=100" qual "Enchant" end
			begin percent "Automatic Spell Study" "??50;50;x;x>=0 and x<=100" qual "Spell" end
			end
	$$timeuse	On the Job
		opt
			begin percent "Automatic Job Study" "??100;100;x;x>=0 and x<=100" qual "Skill" end
			end
	$$timeuse	Adventuring
	$$timeuse	On Holiday
	$$timeuse	At School
	$$timeuse	Training
	end

cat History
	$$devhist	Event
	$$devhist	Job Result
	$$devhist	Skill Increase
	$$devhist	Spell Increase
	$$devhist	Aging		Aging
		opt
			text "Age" ??0
			text "ST Decrease" ??0
			text "DX Decrease" ??0
			text "IQ Decrease" ??0
			text "HT Decrease" ??0
			text "Fatigue Decrease" ??0
			text "Hit Point Decrease" ??0
			end
	$$devhist	Savings	^x|dm(`Amount`)| ^o'Result'
		opt begin adj Amount "availMoney+x" "0" dispexp "format('l: %s', dm(o))" end
			end
	end

cat Jobs 
	colwidth 9 100 100 100 100 100 100 100 100 100 
	sublist "Sample Fantasy/Medieval" 
		colwidth 9 54 100 47 169 149 153 174 100 100 
		sort 2 
		memlist 
		$$job	Servant	1	Main:ST>=7;Main:IQ>=7;Main:DX>=7;Main:HT>=7	120	IQ	LJ/LJ, whipped, 2d
		$$job	Thief*	1	#4,Skills:Thief/Spy>=13|#2,Skills:Thief/Spy>=16	150	DX	3d/3d, caught and tried
		$$job	Bravo*	2	Main:ST>=13;#1,Skills:Combat/Weapon>=14	300	max(st,findItemValue('Skills:Combat/Weapon', 'max', 'level'))-2	2d/4d and jailed
		$$job	Jongleur*	2	Skills:Bard>=14|#1,Skills:Musical>=14	25*max(bard,findItemValue('Skills:Musical', 'max', 'level'))+5*countItems('Skills:Musical', 0, 1, 'level')	max(bard,findItemValue('Skills:Musical', 'max', 'level'))-2	1d, audience throws tomatoes/2d, audience throws rocks
		$$job	Porter	2	Main:ST>=12	300	ST	1d, LJ/2d, LJ
		$$job	Tenant Farmer*	2	Sk:Agronomy>=12;Main:ST>=10	300	12	-1i/-3i, LJ
		$$job	Artisan	3	#1,Skills:Craft>=14	80*findItemValue('Skills:Craft', 'max', 'level')	findItemValue('Skills:Craft', 'max', 'level')-2	LJ/-2i, LJ
		$$job	Free Farmer*	3	Sk:Agronomy>=12;Main:ST>=10	800	12	-1i/-2i, LJ
		$$job	Guard	3	$totalItemValues('Skills:Combat/Weapon', 'level')>=40::$format('Weapon skill levels at least 40 (have %d)',totalItemValues('Skills:Combat/Weapon','level'))	700	findItemValue('Skills:Combat/Weapon', 'max', 'level')	2d/4d, C
		$$job	Soldier	3	$totalItemValues('Skills:Combat/Weapon', 'level')>=40::$format('Weapon skill levels at least 40 (have %d)',totalItemValues('Skills:Combat/Weapon','level'))	700	findItemValue('Skills:Combat/Weapon', 'max', 'level')	2d/4d, C
		$$job	Shopkeeper*	3	Sk:Merchant>=14	80*merchant	merchant-1	-1i/bankrupt
		$$job	Master Artisan*	4	#1,Skills:Craft>=20	170*findItemValue('Skills:Craft', 'max', 'level')	findItemValue('Skills:Craft', 'max', 'level')-4	LJ/LJ, -2i
		$$job	Master Merchant*	4	Skills:Merchant>=16	175*merchant	merchant	-2i/-6i
		$$job	Military Officer	4	$totalItemValues('Skills:Combat/Weapon', 'level')>=60::$format('Weapon skill levels at least 60 (have %d)',totalItemValues('Skills:Combat/Weapon','level'));Sk:Strategy>=14	1100	max(strategy,findItemValue('Skills:Combat/Weapon', 'max', 'level'))	-2i,-3d/-3i, -5d, LJ, lose equipment
		$$job	Knight	4	$totalItemValues('Skills:Combat/Weapon', 'level')>=60::$format('Weapon skill levels at least 60 (have %d)',totalItemValues('Skills:Combat/Weapon','level'));Sk:Strategy>=14	1100	max(strategy,findItemValue('Skills:Combat/Weapon', 'max', 'level'))	-2i,-3d/-3i, -5d, LJ, lose equipment
		$$job	Court Noble	5	Sk:Diplomacy>=13;Sk:Politics>=12;Sk:Savoir-Faire>=14	100*max(diplomacy,politics,savoirfaire)	max(diplomacy,politics,savoirfaire)-1	-1i/-2i, expelled from court, LJ
		$$job	Diplomat	5	Sk:Diplomacy>=13;Sk:Politics>=12;Sk:Savoir-Faire>=14	100*max(diplomacy,politics,savoirfaire)	max(diplomacy,politics,savoirfaire)-1	-1i/-2i, expelled from court, LJ
		$$job	High Church Official	5	Sk:Administration>=12;Sk:Theology>=15	5000	max(administration,theology)	-1i/-2i, declared heretic, LJ
		end 
	$$job	No Job*	1		0			
	$$job	Independent Income			`Percentage`*wealthFunc(0)
		opt percent Percentage "5%"
			end			
	end 

options
	begin text "Display Damage" "" noprint end
	list Advantages
		list "Patron"
			add "Special ability" +5
			add "Supplies" "?:1;Equipment,+5;Costly Equipment,+10"
			end
		list Reputation
			mult "Recognized by" "?:1;Everyone,1;Large class,1/2;Small class,1/3"
			mult "Frequency of Recognition" "?:1;All the time,1;Sometimes (10-),1/2;Occasionally (7-),1/3 "
			end
		end

	list "Additional Attributes"
		text "Starting Level" "??0;0;x;x>=0"
		end

	list Disadvantages
		begin adj "Campaign Disadvantage" campdisadv+@c@ "1" dispexp 'l' noedit noprint end
		begin adj "Racial Disadvantage" campdisadv+@c@ "1" dispexp 'l' noedit noprint end
		mult "Frequency of Submission" "?:2;Quite rarely (6-),1/2;Fairly often (9-),1;Quite often (12-),2;Almost all the time (15-),3"
		list Addiction
			add "Addictiveness" "?:1;Normal,-0;Highly,-5;Totally,-10"
			add "Incapacitating or Hallucinogenic" -10
			add "Legal" +5
			end
		list "Dependent"
			mult "Appears" "?:1;Quite rarely (6-),1/2;Fairly often (9-),1;Quite often (12-),2;Almost all the time (15-),3"
			mult "Relationship" "?:1;Employer or acquaintance,1/2;Friend,1;Loved one,2"
			end
		end

	list Jobs
		begin text "Pay Raises" ??0;0;x;x>=-100 dispexp "'l: o%'" end
		begin adj "Cost of Living" "costOfLiving+x" "0" dispexp "format('l: %s', dm(o))" end
		begin text "Lost Job" "?+1;" dispexp 'l' end
		end

	list Generic
		begin add Addition +10 keepold end
		begin adj Adjustment Var+x 1 keepold end
		begin auxcost "Auxiliary Cost" 5*x 1 keepold end
		begin text Category "Category" noprint cat Category keepold end
		begin exp Expression x keepold end
		begin text "File Name" "" noprint editdlg 1 end
		begin mult Multiplier 1/2 keepold end
		begin text Note Text keepold end
		begin percent Percent +10% keepold end
		begin add Subtraction -10 keepold end
		begin text Text Text keepold end
		end
	list Equipment
		text ACC ??1
		text "Extra Accuracy" ??1
		begin text "Base Price" 10 keepold end
		begin adj "Blocking Shield" "block=integer((`Skill`)/2)" "" noprint end
		exp "Crushing Damage" "sw(0+`Extra Damage`)"
		exp "Cutting Damage" "sw(0+`Extra Damage`)"
		adj DR adr+x 1
		text "Extra Damage" ??1;1;x;x>0
		text "Extra DR" "??1;1;x;x>0"
		text "Extra PD" "??1;1;x;x>0"
		exp "Half DMG" integer(ST1.5)
		exp "Impaling Damage" "thr(0+`Extra Damage`)"
		exp MAX ST
		begin text "Military Issue" "?+1;" dispexp 'l' alias "No Cost" noprint end
		begin text "No Weapon Master Damage Bonus" "?+1;" dispexp 'l' noprint end
		begin text "No Cost" ?+1; dispexp 'l' noprint end
		adj PD apd+x 1
		list "Possession Enchantments"
			mult "Lighten" "?:1;1/2,1/2;3/4,3/4"
			end
		adj Price posscost+x 0
		begin mult Quantity "??1;1;x;x>0" noprint end
		exp Skill skill>0?skill:'--'
		text SS ??10
		begin text "Weapon Quality" "?:1;Good,1;Cheap,2;Fine,3;Very fine,4" dispexp "'l: t'" end
		end
	list "Martial Arts"
		begin text "Style Maneuver" "?+1;" dispexp 'l' noprint end
		end
	list Printing
		begin text "Display on Control Sheet" "?+1;" noprint dispexp "'l'" end
		begin text "Omit on Control Sheet" "?+1;" noprint dispexp "'l'" end
		text Roll ""
		end
	list Quirks
		begin adj "Racial Quirk" racialQuirks+@c@ "1" dispexp 'l' noedit noprint end
		end
	list Skills
		begin text Default "" noprint keepold end
		mult Hobby 1/2
		begin text "Show Parry" "?+1;" dispexp 'l' noprint end
		begin text "Show Block" "?+1;" dispexp 'l' noprint end
		begin exp TL tl+&tl noprint keepold end
		begin text "Minimum Cost" "??0;0;x;x>=0" dispexp "'l: o'" noprint end
		begin text "Minimum Level" "??0;0;x;x>=0" noprint end
		begin exp "Base Level" "0" noprint keepold end
		begin text Specialty "" keepold noprint end
		end
	list Spells
		begin text "Combat Spell" "" dispexp 'l' cat Combat noedit end
		begin text "Thief Spell" "" dispexp 'l' cat Thief noedit end
		begin exp "Required Level" "0" noprint keepold end
		begin text "Required Cost" "??0" noprint end
		end
	list "Super Powers"
		begin text "LC" "??5;5;x" noprint end
		begin text "Base Attribute" 12 noprint end
		begin text "Use Skill" "" noprint end
		end
	list "Time Use"
		begin add "Study Skill" "??Hours per Week" qual Skll end
		begin add "Study Spell" "??Hours per Week" qual Spell end
		add "Other Time Use" ??0
		begin text "Skill Study Bonus" "??Hours per Week" qual Skill end
		begin text "Spell Study Bonus"  "??Hours per Week" qual Skill end
		begin percent "Automatic Job Study" "??100;100;x;x>=0 and x<=100" qual "Skill" end
		begin percent "Automatic Spell Study" "??100;100;x;x>=0 and x<=100" qual "Spell" end
		begin text "Automatic Foreign Language Study" "??4;4;x;x<=4 and x>=0" qual "Language" dispexp "'l: o hours per day'" end
		begin text "Hours Studied" ??0;0;x;x>=0 noprint end
		list "Time"
			begin adj "Months per Year" "monthsPerYear=x" "??12;12;x;x>0" end
			begin adj "Weeks per Year" "weeksPerYear=x" "??52;52;x;x>0" end
			begin adj "Days per Week" "daysPerWeek=x" "??7;7;x;x>0" end
			begin adj "Hours per Day" "hoursPerDay=x" "??24;24;x;x>0" end
			end
		end

	end
end
